/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.service.impl;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.service.ITopicMessageListener;
import com.ericsson.cms.neptune.cluster.service.ITopicService;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.Validate;

public class DistributedTopic<M>
implements ITopicService<M> {
    private final String name;
    private ITopic<M> topic;
    private MessageListener<M> messageListener = null;
    private List<ITopicMessageListener<M>> subscribers;
    private IClusterService clusterService;
    private String messageListenerId;

    public DistributedTopic(String name) {
        this.name = name;
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    @PostConstruct
    public void start() {
        Validate.notNull((Object)this.clusterService, (String)"clusterService cannot be null");
        this.topic = this.clusterService.getInstance().getTopic(this.getServiceName());
        this.messageListener = new TopicListener();
        this.subscribers = Collections.synchronizedList(new ArrayList());
    }

    @Override
    @PreDestroy
    public void stop() {
        if (this.messageListenerId != null) {
            this.topic.removeMessageListener(this.messageListenerId);
        }
        this.subscribers.clear();
        this.topic = null;
        this.messageListener = null;
        this.subscribers = null;
    }

    @Override
    public void publish(M message) {
        this.topic.publish(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(ITopicMessageListener<M> listener) {
        if (listener != null) {
            List<ITopicMessageListener<M>> list = this.subscribers;
            synchronized (list) {
                if (this.subscribers.size() == 0) {
                    this.messageListenerId = this.topic.addMessageListener(this.messageListener);
                }
                this.subscribers.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(ITopicMessageListener<M> listener) {
        List<ITopicMessageListener<M>> list = this.subscribers;
        synchronized (list) {
            this.subscribers.remove(listener);
            if (this.subscribers.size() == 0) {
                this.topic.removeMessageListener(this.messageListenerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySubscribers(M message) {
        ArrayList<ITopicMessageListener<M>> copy = null;
        List<ITopicMessageListener<M>> list = this.subscribers;
        synchronized (list) {
            copy = new ArrayList<ITopicMessageListener<M>>(this.subscribers);
        }
        for (ITopicMessageListener iTopicMessageListener : copy) {
            iTopicMessageListener.onMessage(message);
        }
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    private final class TopicListener
    implements MessageListener<M> {
        private TopicListener() {
        }

        public void onMessage(Message<M> message) {
            DistributedTopic.this.notifySubscribers(message.getMessageObject());
        }
    }
}

