/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.User;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import com.ericsson.neptune.security.filter.AuthenticationException;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import com.ericsson.neptune.security.filter.helper.UsersCacheManager;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthorizationFilter
extends BaseSecurityFilter {
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_URLS_PROPERTIES = "neptune_sso_oauth2_provider_urls_properties";
    protected static final String NEPTUNE_SSO_WEBSERVICE_URL = "neptune_sso_webservice_url";
    private String webserviceUrl;
    private AuthProviderClient providerClient;
    private static final String USER_SERVICES = "services";

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        User user;
        NeptunePrincipal principal;
        this.logger.debug((Object)"AuthorizationFilter interrupting the request");
        if (!this.isNeptune) {
            principal = this.getPrincipal(request);
            user = principal != null && principal.getUserName().equals(USER_SERVICES) ? UsersCacheManager.getInstance().getUser(principal.getUserName()) : this.providerClient.getUser(this.webserviceUrl, request, principal);
            if (user == null) {
                this.logger.error((Object)"Unable to get the user from the users web service");
                throw new AuthenticationException("Invalid user credentials");
            }
            if (principal == null) {
                principal = new NeptunePrincipal();
                principal.setUserName(user.getUserName());
            }
        } else {
            this.logger.error((Object)"Wrong filter configuration.Should have configured the LocalAuthorizationFilter for Neptune.");
            response.sendError(417, "This component is not Neptune. Need to configure webservice url in provider properties file");
            return;
        }
        principal.setRoles(user.getRoleSets());
        request.setAttribute("neptune_sso_oauth2_principal", (Object)principal);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private NeptunePrincipal getPrincipal(HttpServletRequest request) {
        NeptunePrincipal result = (NeptunePrincipal)request.getAttribute("neptune_sso_oauth2_principal");
        if (result == null && request.getSession(false) != null) {
            result = (NeptunePrincipal)request.getSession(false).getAttribute("neptune_sso_oauth2_principal");
        }
        return result;
    }

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.providerClient = new AuthProviderClient();
        if (!this.isNeptune) {
            this.webserviceUrl = this.providerUrls.getProperty(NEPTUNE_SSO_WEBSERVICE_URL);
        }
    }
}

