/*
 * Created on May 13, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.server;

import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;

/**
 * Provides access to the authorization manager EJB service and ensures that the user has required
 * permissions when receiving a call from the server side of the UI.
 * 
 * @author Vijay Silva
 */
public class NeptuneAuthorizationManager {

	private static final String AUTHORIZATION_SERVICE = "cms/AuthorizationService/local";

	/* Constructor */
	private NeptuneAuthorizationManager() {
	}

	/**
	 * Get the authorization service
	 * 
	 * @return The authorization service
	 */
	public static IAuthorizationService getAuthorizationService() {
		return InjectionUtil.injectInstance(AUTHORIZATION_SERVICE, IAuthorizationService.class);
	}

	/**
	 * Determine if the currently logged in user has the input permissions
	 * 
	 * @param permissions The permissions
	 * @return true if the user has permissions, false otherwise
	 */
	public static boolean hasPermission(String... permissions) {
		IAuthorizationService authorizationService = getAuthorizationService();

		for (String permission : permissions) {
			if (!authorizationService.isAuthorized(permission))
				return false;
		}

		return true;
	}

	/**
	 * Check if the user has permissions, and fail if the user is not authorized
	 * 
	 * @param permissions The permissions
	 * @throws Exception if the user is not authorized
	 */
	public static void isAuthorized(String... permissions) throws InsufficientRolesException {
		if (!hasPermission(permissions)) {
			throw new InsufficientRolesException();
		}
	}
}
