/*
 * Created on Jan 25, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.user.model;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Stores a User Key
 * 
 * @author Vijay Silva
 */
public class UiUserKey implements IsSerializable {

	private static final String ENTRY_SEPARATOR = ":::";

	private Long id;

	/**
	 * Default Constructor
	 */
	public UiUserKey() {
	}

	/**
	 * Constructs a UiUserKey with the given ID and external key
	 * 
	 * @param id The role ID
	 * @param externalKey The external key
	 */
	public UiUserKey(Long id, String externalKey) {
		this.id = id;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public boolean isValueAssigned() {
		return (id != null);
	}

	/*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return (id != null) ? (id.hashCode() + 23) : super.hashCode();
	}

	/*
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;

		if (!(obj instanceof UiUserKey))
			return false;

		/* IDs must be equal */
		UiUserKey other = (UiUserKey) obj;
		return (id != null && id.equals(other.id));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return (id == null) ? "" : id.toString();
	}

	/**
	 * Parse the string generated from the toString() method of UiUserKey to a UiUserKey object.
	 * 
	 * @param userKey String representation of a UiUserKey
	 * @return The UiUserKey object parsed from the string
	 */
	public static UiUserKey parse(String userKey) {
		UiUserKey result = new UiUserKey();

		if (userKey == null)
			throw new RuntimeException("Cannot parse null string to UiUserKey.");

		/*
		 * For backwards compatibility, assume entry separator can exist in string. Since external
		 * key is removed, the entry separator is no longer used. To support old bookmarks, continue
		 * to parse expecting the entry separator. Example: 45:::test should continue to be valid.
		 */
		String[] entries = userKey.split(ENTRY_SEPARATOR, 2);
		String idValue = entries[0].trim();
		if (idValue.length() > 0)
			result.id = Long.parseLong(idValue);

		return result;
	}
}
