/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class JBossJAASUIFilter
extends BaseSecurityFilter {
    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.logger.info((Object)"init started...");
    }

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.logger.debug((Object)"JBossJAASUIFilter interrupting the request");
        HttpSession session = this.getSession(request);
        if (session == null) {
            this.logger.debug((Object)"no session found, just continue");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.isLogoutRequested(request, (ServletResponse)response)) {
            this.logoutJAASUser(request);
            return;
        }
        if (request.getUserPrincipal() == null) {
            NeptunePrincipal principal = (NeptunePrincipal)session.getAttribute("neptune_sso_oauth2_principal");
            if (principal == null) {
                this.logger.debug((Object)"Could not get Neptune Principal from Session");
                throw new ServletException("Could not get Neptune Principal from Session");
            }
            String password = "";
            this.mapSSOUserToJAASUser(request, principal.getUserName(), password);
        }
        this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void mapSSOUserToJAASUser(HttpServletRequest request, String userName, String password) {
        this.logger.debug((Object)"Calling web authentication login");
        HttpSession session = this.getSession(request);
        try {
            request.login(userName, password);
        }
        catch (ServletException e) {
            this.logger.error((Object)"Http request login failed!", (Throwable)e);
            return;
        }
        session.setAttribute("username", (Object)userName);
    }

    private HttpSession getSession(HttpServletRequest request) {
        return request.getSession(false);
    }

    private void logoutJAASUser(HttpServletRequest request) throws ServletException {
        HttpSession session = this.getSession(request);
        session.removeAttribute("username");
        if (request.getUserPrincipal() != null) {
            request.logout();
        }
    }
}

