/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.clustermgmt.ejb;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.neptune.clustermgmt.NodeMembershipListener;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.ericsson.neptune.clustermgmt.service.IClusterConfigurationService;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MembershipListener;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.apache.log4j.Logger;

@Startup
@Singleton(name="Neptune:service=com.tandbergtv.neptune.clustermgmt.service.IClusterConfigurationService")
@Local(value={IClusterConfigurationService.class})
public class ClusterConfigurationService
implements IClusterConfigurationService {
    private static final Logger log = Logger.getLogger(ClusterConfigurationService.class);
    private IClusterService clusterService;

    @PostConstruct
    public void create() {
        this.joinCluster();
    }

    @PreDestroy
    public void destroy() {
        this.leaveCluster();
    }

    private void joinCluster() {
        try {
            log.info((Object)"Initializing Hazelcast...");
            this.clusterService = this.getClusterService(ClusterConstant.CLUSTER_CONFIG_PATH);
            this.clusterService.getInstance().getCluster().addMembershipListener((MembershipListener)new NodeMembershipListener());
            log.info((Object)"Hazelcast has been initialized.");
        }
        catch (Exception e) {
            log.error((Object)"Can not join cluster", (Throwable)e);
            throw new IllegalStateException("cannot start Hazelcast", e);
        }
    }

    protected IClusterService getClusterService(String path) {
        return Cluster.getService((String)path);
    }

    private void leaveCluster() {
        log.info((Object)"Leaving Hazelcast cluster");
        this.clusterService.stop();
        log.info((Object)"Left Hazelcast cluster");
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.clusterService.getInstance();
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }
}

