/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.settings.cache;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.tandbergtv.neptune.settings.cache.SettingsCache;
import com.tandbergtv.neptune.settings.cache.SettingsChangeHazelcastMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SettingsMessageListener
implements MessageListener<SettingsChangeHazelcastMessage> {
    private static final Logger logger = Logger.getLogger(SettingsMessageListener.class);
    private IClusterService clusterService;
    private SettingsCache settingsCache;

    public SettingsMessageListener(IClusterService clusterService, SettingsCache settingsCache) {
        this.clusterService = clusterService;
        this.settingsCache = settingsCache;
    }

    public void onMessage(Message<SettingsChangeHazelcastMessage> message) {
        SettingsChangeHazelcastMessage msg = (SettingsChangeHazelcastMessage)message.getMessageObject();
        try {
            if (StringUtils.isBlank((String)msg.getGroupPath()) || msg.getSender() == null) {
                return;
            }
            logger.debug((Object)("SettingsChangeHazelcastMessage received - Msg:" + msg.getGroupPath() + ":" + msg.getSender().getHostName()));
            if (this.clusterService.getLocalMember().getSocketAddress().equals(msg.getSender())) {
                return;
            }
            this.settingsCache.updateGroup(msg.getGroupPath());
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to update local cache", t);
        }
    }
}

