/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.actionItems.cache;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MigrationEvent;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import com.tandbergtv.neptune.actionItems.cache.AbstractCompositeCache;
import java.io.Serializable;
import java.util.Collection;

public class ReplicatedCompositeCache<T>
extends AbstractCompositeCache<T> {
    public ReplicatedCompositeCache(String name, int size) {
        super(name, size);
    }

    @Override
    public T get(Serializable key) {
        return this.cache.get(key);
    }

    @Override
    public Collection<Serializable> getKeys() {
        return this.cache.getKeys();
    }

    @Override
    public void start() {
        super.start();
        this.addMapListener();
    }

    protected void addMapListener() {
        IMap map = (IMap)this.getMap();
        map.addEntryListener((MapListener)new EntryAddedListener<Serializable, T>(){

            public void entryAdded(EntryEvent<Serializable, T> event) {
                if (ReplicatedCompositeCache.this.external(event)) {
                    ReplicatedCompositeCache.this.cache.add((Serializable)event.getKey(), event.getValue());
                }
            }
        }, true);
        map.addEntryListener((MapListener)new EntryEvictedListener<Serializable, T>(){

            public void entryEvicted(EntryEvent<Serializable, T> event) {
                if (ReplicatedCompositeCache.this.external(event)) {
                    ReplicatedCompositeCache.this.cache.remove((Serializable)event.getKey());
                }
            }
        }, true);
        map.addEntryListener((MapListener)new EntryRemovedListener<Serializable, T>(){

            public void entryRemoved(EntryEvent<Serializable, T> event) {
                if (ReplicatedCompositeCache.this.external(event)) {
                    ReplicatedCompositeCache.this.cache.remove((Serializable)event.getKey());
                }
            }
        }, true);
        map.addEntryListener((MapListener)new EntryUpdatedListener<Serializable, T>(){

            public void entryUpdated(EntryEvent<Serializable, T> event) {
                if (ReplicatedCompositeCache.this.external(event)) {
                    ReplicatedCompositeCache.this.cache.add((Serializable)event.getKey(), event.getValue());
                }
            }
        }, true);
    }

    @Override
    protected MigrationListener getMigrationListener() {
        return new MigrationListener(){

            public void migrationStarted(MigrationEvent migrationEvent) {
            }

            public void migrationCompleted(MigrationEvent migrationEvent) {
            }

            public void migrationFailed(MigrationEvent migrationEvent) {
            }
        };
    }

    protected boolean external(EntryEvent<Serializable, T> event) {
        return !this.getClusterService().getLocalMember().equals(event.getMember());
    }
}

