/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.service.impl;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.service.IDistributedSchedulerService;
import com.ericsson.cms.neptune.cluster.task.MultiFuture;
import com.ericsson.cms.neptune.cluster.util.SchedulerUtils;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.core.IExecutorService;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.Validate;

public class DistributedScheduler<T>
implements IDistributedSchedulerService<T> {
    private final String name;
    private final int size;
    private IExecutorService executor;
    private IClusterService clusterService;

    public DistributedScheduler(String name) {
        this(name, 1);
    }

    public DistributedScheduler(String name, int size) {
        this.name = name;
        this.size = size;
    }

    @Override
    public Future<T> schedule(Callable<T> callable) {
        if (this.executor == null) {
            throw new IllegalStateException("Scheduler " + this.name + " has not started");
        }
        return SchedulerUtils.submitTask(callable, this.getExecutor(), this.clusterService);
    }

    @Override
    public Future<Collection<T>> scheduleMulti(Callable<T> callable) {
        if (this.executor == null) {
            throw new IllegalStateException("Scheduler " + this.name + " has not started");
        }
        return new MultiFuture(this.executor.submitToAllMembers(callable).values());
    }

    @Override
    @PostConstruct
    public void start() {
        Validate.notNull((Object)this.clusterService, (String)"clusterService cannot be null");
        ExecutorConfig ec = new ExecutorConfig(this.name, this.size);
        this.clusterService.getInstance().getConfig().addExecutorConfig(ec);
        this.executor = this.clusterService.getInstance().getExecutorService(this.name);
    }

    @Override
    @PreDestroy
    public void stop() {
        this.executor = null;
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    protected IExecutorService getExecutor() {
        return this.executor;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected IClusterService getClusterService() {
        return this.clusterService;
    }
}

