/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.sync.scan;

import com.ericsson.neptune.usermgmt.sync.scan.IUserChangeScanner;
import com.ericsson.neptune.usermgmt.sync.scan.factory.IUserScanWorkerFactory;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.usermgmt.external.UserConfigurationFactory;
import com.tandbergtv.neptune.usermgmt.external.ad.ActiveDirectorySyncUserConfigurationFactory;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class SimpleLDAPUserChangeScanner
implements IUserChangeScanner {
    private static Logger logger = Logger.getLogger(SimpleLDAPUserChangeScanner.class);
    private static Class[] SUPPORTED_FACTORYS = new Class[]{ActiveDirectorySyncUserConfigurationFactory.class};
    private int batchSize = 5;
    private IUserManager userManager;
    private IUserScanWorkerFactory userScanWorkerFactory;
    private ExecutorService executorService;

    @Override
    public List<String> scan() {
        List<User> dbUsers = this.userManager.getExternalUsers();
        int index = 0;
        while (index < dbUsers.size()) {
            int end = index + this.batchSize - 1 < dbUsers.size() ? index + this.batchSize - 1 : dbUsers.size() - 1;
            List<User> batch = dbUsers.subList(index, end + 1);
            index = end + 1;
            Runnable worker = this.userScanWorkerFactory.createWorker(batch);
            try {
                logger.info((Object)("checking users[" + batch + "]"));
                this.executorService.submit(worker);
            }
            catch (Exception e) {
                logger.warn((Object)"cannot perform user changes scan task", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isSupported(Class<? extends UserConfigurationFactory> factoryClass) {
        return ArrayUtils.contains((Object[])SUPPORTED_FACTORYS, factoryClass);
    }

    public void setUserManager(IUserManager userManager) {
        this.userManager = userManager;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize cannot be less than 1");
        }
        this.batchSize = batchSize;
    }

    public void setUserScanWorkerFactory(IUserScanWorkerFactory userScanWorkerFactory) {
        this.userScanWorkerFactory = userScanWorkerFactory;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

