/**
 * Credentials.java
 * Created on May 26, 2009
 * (C) Copyright TANDBERG Television Ltd.
 */
package com.tandbergtv.neptune.ui.framework.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Class that holds the user's username and the list of roles
 *  
 * @author Vlada Jakobac
 *
 */
public class Credentials implements IsSerializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String username;
	private List<String> roles = new ArrayList<String>();
	
	public Credentials() {
		
	}
	
	public Credentials(String username, List<String> roles) {
		this.username = username;
		this.roles = roles;
	}
	
	/**
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param username the username to set
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * @return the roles
	 */
	public List<String> getRoles() {
		return roles;
	}

	/**
	 * @param roles the roles to set
	 */
	public void setRoles(List<String> roles) {
		this.roles = roles;
	}

	
	
	
}
