/*
 * Created on Aug 15, 2011
 * 
 * (C) Copyright Ericsson Television Inc.
 */
package com.tandbergtv.neptune.widgettoolkit.server.internal;

import static com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal.ServerTime.INTERNAL_DATETIME_PATTERN;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal.IServerTimeService;
import com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal.ServerTime;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;

/**
 * Implementation of the {@link IServerTimeService} RPC service
 * <p>
 * WARNING: DO NOT USE this class directly. This is not part of the Neptune API!
 * </p>
 * 
 * @author Vijay Silva
 */
public class ServerTimeService implements NeptuneRemoteService, IServerTimeService {

	/**
	 * Constructor
	 */
	public ServerTimeService() {
	}

	@Override
	public ServerTime getCurrentTime() throws NeptuneException {
		int offsetInMillis = java.util.TimeZone.getDefault().getRawOffset();
		int offsetInMinutes = (int) TimeUnit.MILLISECONDS.toMinutes(offsetInMillis);

		Date currentTime = new Date();
		String dateString = new SimpleDateFormat(INTERNAL_DATETIME_PATTERN).format(currentTime);

		return new ServerTime(offsetInMinutes, currentTime, dateString);
	}

	@Override
	public String getRelativePath() {
		return "service/neptune/IServerTimeService";
	}

	@Override
	public Class<?> getServiceImplementation() {
		return this.getClass();
	}
}
