/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.actions;

import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.marvin.udt.GenericType;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class NormalizationChangeAction {
    private String sectionType;
    private String rootxpath;
    private String xpath;
    private Boolean forMatched;
    private GenericType value;
    private EvaluatorResults evalResults;
    private Title title;

    public NormalizationChangeAction(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        this.sectionType = sectionType;
        this.rootxpath = rootxpath;
        this.xpath = xpath;
        this.forMatched = forMatched;
        this.value = value;
        this.evalResults = evalResults;
        this.title = title;
    }

    public void change() {
        List<String> tokenizededPath = this.tokenizeXpath(this.xpath);
        if (this.forMatched.booleanValue() && this.rootxpath != null && !this.sectionType.equals(this.rootxpath)) {
            for (FieldTree matchedItem : this.evalResults.getMatchedItems()) {
                FieldTreeNode root = matchedItem.getRootElement();
                if (!root.getName().equals(this.rootxpath)) continue;
                Asset asset = this.getMatchedItemAsset(root);
                FieldTreeNode startingNode = (FieldTreeNode)root.getChildren().get(0);
                ArrayList<Integer> indices = new ArrayList<Integer>();
                indices.add(1);
                if (asset == null || !startingNode.getName().equals(tokenizededPath.get(1))) continue;
                this.walkTree(1, tokenizededPath, startingNode, this.xpath, this.value, indices, asset);
            }
        } else {
            List<Asset> affectedAssets;
            if (this.forMatched.booleanValue()) {
                affectedAssets = new ArrayList();
                for (Asset a : this.evalResults.getMatchedAssets()) {
                    if (!a.getAssetType().equals(this.sectionType)) continue;
                    affectedAssets.add(a);
                }
            } else {
                affectedAssets = this.title.getAsset().getAllAssetsOfType(this.sectionType);
            }
            for (Asset affectedAsset : affectedAssets) {
                FieldTreeNode root = affectedAsset.getFieldTree().getRootElement();
                if (!root.getName().equals(tokenizededPath.get(0))) continue;
                this.walkTree(0, tokenizededPath, root, this.xpath, this.value, new ArrayList<Integer>(), affectedAsset);
            }
        }
    }

    private Asset getMatchedItemAsset(FieldTreeNode node) {
        if (node.getField() != null) {
            return node.getField().getParentAsset();
        }
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                Asset childResult = this.getMatchedItemAsset(child);
                if (childResult == null) continue;
                return childResult;
            }
        }
        return null;
    }

    private boolean walkTree(int listPos, List<String> tokenizedXpath, FieldTreeNode node, String xpath, GenericType value, List<Integer> indices, Asset asset) {
        List children = node.getChildren();
        Field currField = node.getField();
        boolean addedOrChanged = false;
        int newPos = listPos + 1;
        indices.add(node.getCurrentIndex());
        if (currField != null && currField.getTtvXPath().equals(xpath)) {
            currField.setTypedValue(value.getTypedObject());
            addedOrChanged = true;
        } else if (children != null && children.size() > 0 && newPos < tokenizedXpath.size()) {
            for (FieldTreeNode child : children) {
                if (!tokenizedXpath.get(newPos).equals(child.getName()) || !this.walkTree(newPos, tokenizedXpath, child, xpath, value, indices, asset)) continue;
                addedOrChanged = true;
            }
        }
        if (!addedOrChanged) {
            List<Integer> newIndices = this.cloneIndices(indices);
            int stopPos = tokenizedXpath.size();
            if (tokenizedXpath.get(tokenizedXpath.size() - 1).startsWith("@")) {
                --stopPos;
            }
            int i = newPos;
            while (i < stopPos) {
                newIndices.add(1);
                ++i;
            }
            Field field = this.buildField(newIndices, xpath, value);
            asset.addField(field);
            this.evalResults.updateMatchedItems(field, tokenizedXpath);
            addedOrChanged = true;
        }
        indices.remove(indices.size() - 1);
        return addedOrChanged;
    }

    private Field buildField(List<Integer> indices, String xpath, GenericType value) {
        Field field = new Field();
        field.setTtvXPath(xpath);
        field.setIndices(indices);
        field.setDataType(value.getDataType().getDataTypeName());
        field.setTypedValue(value.getTypedObject());
        return field;
    }

    private List<String> tokenizeXpath(String xpath) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(xpath, "/", false);
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            if (str.startsWith("tns:")) {
                str = str.substring(4);
            }
            tokens.add(str);
        }
        return tokens;
    }

    private List<Integer> cloneIndices(List<Integer> indices) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer index : indices) {
            result.add(index);
        }
        return result;
    }
}

