/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.actions;

import com.tandbergtv.marvin.actions.Action;
import com.tandbergtv.marvin.metadata.ActionAnnotations;
import com.tandbergtv.marvin.udt.ActionMessage;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

@ActionAnnotations(name="PROCESSING")
public class ProcessingActions
extends Action {
    private static final String TEMPLATE_NAME_PARAM = "_template";
    private static final String COMMAND_NAME = "create";
    private static final String UID = "re0101";
    private static final Logger logger = Logger.getLogger(ProcessingActions.class);
    private List<ActionMessage> messages = new ArrayList<ActionMessage>();

    @ActionAnnotations.Action(name="startWorkOrderLabel", parms={"templateName", "title"}, parmLabels={"", ""}, xpathFilter={})
    public ActionMessage startWorkOrder(String templateName, Title title) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)UID);
        WPCLCommand command = new WPCLCommand(COMMAND_NAME);
        command.addParameter(TEMPLATE_NAME_PARAM, templateName);
        message.setCommand(command);
        message.getPayload().putValue("titleId", title.getId().toString());
        IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
        ActionMessage resultMessage = new ActionMessage();
        try {
            router.send(this.getMessage(message));
            String stringMessage = "Kicked off " + templateName + " template for titleId " + title.getId() + ".";
            logger.info((Object)stringMessage);
            resultMessage.setMessage(stringMessage);
        }
        catch (Exception e) {
            String stringMessage = "DUDE, there was an error when kicking off " + templateName + " from the actionator for titleId " + title.getId() + ".";
            logger.error((Object)stringMessage, (Throwable)e);
            resultMessage.setMessage(stringMessage);
        }
        return resultMessage;
    }

    private IMessage getMessage(WorkflowMessage wpcl) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(wpcl);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(writer));
        return new MessageImpl((IPayload)new StringPayload(writer.getBuffer().toString()));
    }

    public void printMessages() {
        for (ActionMessage message : this.messages) {
            System.out.println(message.getMessage());
        }
    }

    public void cleanUpAction() {
        this.printMessages();
    }
}

