/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.actions;

import com.tandbergtv.marvin.actions.Action;
import com.tandbergtv.marvin.metadata.ActionAnnotations;
import com.tandbergtv.marvin.udt.ValidationMessage;
import com.tandbergtv.marvin.udt.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

@ActionAnnotations(name="VALIDATION")
public class ValidationActions
extends Action {
    private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

    @ActionAnnotations.Action(name="raiseWarningLabel", parms={"message"}, parmLabels={""}, xpathFilter={})
    public ValidationMessage raiseWarning(String message) {
        return this.raiseMessage(ValidationMessageType.Warning, message);
    }

    @ActionAnnotations.Action(name="raiseErrorLabel", parms={"message"}, parmLabels={""}, xpathFilter={})
    public ValidationMessage raiseError(String message) {
        return this.raiseMessage(ValidationMessageType.Error, message);
    }

    @ActionAnnotations.Action(name="raiseInfoLabel", parms={"message"}, parmLabels={""}, xpathFilter={})
    public ValidationMessage raiseInfo(String message) {
        return this.raiseMessage(ValidationMessageType.Info, message);
    }

    public ValidationMessage raiseMessage(ValidationMessageType vmt, String message) {
        ValidationMessage vm = new ValidationMessage(vmt, message);
        this.messages.add(vm);
        return vm;
    }

    public void printMessages() {
        for (ValidationMessage message : this.messages) {
            System.out.println(message.getMessage());
        }
    }

    public void cleanUpAction() {
        this.printMessages();
    }

    public void setMessages(List<ValidationMessage> messages) {
        this.messages = messages;
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }
}

