/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldBase;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class EvaluatorResults {
    private List<String> matchedItemKeys = new ArrayList<String>();
    private List<FieldTree> matchedItems = new ArrayList<FieldTree>();
    private List<Asset> matchedAssets = new ArrayList<Asset>();
    private boolean passed;

    public EvaluatorResults() {
        this.passed = false;
    }

    public EvaluatorResults(boolean passed) {
        this.passed = passed;
    }

    public List<FieldTree> getMatchedItems() {
        return this.matchedItems;
    }

    public void addMatchedItem(FieldTree matchedItem) {
        if (matchedItem != null && !this.matchedItemsContainsValue(matchedItem)) {
            String name = matchedItem.getRootElement().getName();
            List<Integer> indices = this.getBaseIndices(matchedItem);
            this.matchedItems.add(matchedItem);
            this.matchedItemKeys.add(FieldBase.buildTtvXPathWithIndices((String)name, indices));
        }
    }

    private boolean matchedItemsContainsValue(FieldTree fieldTree) {
        for (FieldTree ftree : this.matchedItems) {
            if (!ftree.getRootElement().equals((Object)fieldTree.getRootElement())) continue;
            return true;
        }
        return false;
    }

    public void setMatchedItems(List<FieldTree> matchedItems) {
        this.matchedItems = matchedItems;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    public boolean passed() {
        return this.passed;
    }

    public List<Asset> getMatchedAssets() {
        return this.matchedAssets;
    }

    public void addMatchedAsset(Asset matchedAsset) {
        if (matchedAsset == null) {
            return;
        }
        for (Asset asset : this.matchedAssets) {
            if (asset.getId() != matchedAsset.getId()) continue;
            return;
        }
        this.matchedAssets.add(matchedAsset);
    }

    public void updateMatchedItems(Field field, List<String> fieldTokenizededPath) {
        String key = field.getTtvXPathWithIndices();
        int i = 0;
        while (i < this.matchedItemKeys.size()) {
            if ((key = String.valueOf(key) + "/").startsWith(String.valueOf(this.matchedItemKeys.get(i)) + "/")) {
                FieldTreeNode node = (FieldTreeNode)this.matchedItems.get(i).getRootElement().getChildren().get(0);
                this.addFieldToFieldTree(node, field, fieldTokenizededPath, 1);
            }
            ++i;
        }
    }

    private boolean addFieldToFieldTree(FieldTreeNode node, Field field, List<String> fieldTokenizededPath, int fieldIndicePos) {
        boolean added = false;
        if (node.getName().equals(fieldTokenizededPath.get(fieldIndicePos)) && node.getCurrentIndex().equals(field.getIndices().get(fieldIndicePos))) {
            int i = 0;
            List children = node.getChildren();
            while (!added && i < children.size()) {
                added = this.addFieldToFieldTree((FieldTreeNode)children.get(i), field, fieldTokenizededPath, fieldIndicePos + 1);
                ++i;
            }
            if (!added) {
                added = true;
                FieldTreeNode newNode = this.buildFieldTreeNode(field, fieldTokenizededPath, fieldIndicePos + 1);
                node.addChild(newNode);
            }
        }
        return added;
    }

    private FieldTreeNode buildFieldTreeNode(Field field, List<String> tokenizedXpath, int currPos) {
        FieldTreeNode fieldTreeNode;
        FieldTreeNode root = null;
        FieldTreeNode curr = null;
        int i = currPos;
        while (i < tokenizedXpath.size() - 1) {
            fieldTreeNode = new FieldTreeNode();
            fieldTreeNode.setName(tokenizedXpath.get(i));
            fieldTreeNode.setCurrentIndex((Integer)field.getIndices().get(i));
            if (curr == null) {
                root = fieldTreeNode;
                curr = fieldTreeNode;
            } else {
                curr.addChild(fieldTreeNode);
                curr = fieldTreeNode;
            }
            ++i;
        }
        int finalPos = tokenizedXpath.size() - 1;
        fieldTreeNode = new FieldTreeNode();
        fieldTreeNode.setField(field);
        fieldTreeNode.setName(tokenizedXpath.get(finalPos));
        if (finalPos < field.getIndices().size()) {
            fieldTreeNode.setCurrentIndex((Integer)field.getIndices().get(finalPos));
        } else {
            fieldTreeNode.setCurrentIndex(Integer.valueOf(1));
        }
        if (curr == null) {
            return fieldTreeNode;
        }
        curr.addChild(fieldTreeNode);
        return root;
    }

    private List<Integer> getBaseIndices(FieldTree tree) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        String name = tree.getRootElement().getName();
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        FieldTreeNode startingNode = (FieldTreeNode)tree.getRootElement().getChildren().get(0);
        int depth = tokenizer.countTokens();
        if (!startingNode.getName().equalsIgnoreCase("Fields")) {
            --depth;
            indices.add(1);
        }
        this.getBaseIndices(startingNode, indices, depth);
        return indices;
    }

    private void getBaseIndices(FieldTreeNode node, List<Integer> indices, int depth) {
        List children = node.getChildren();
        if (depth > 0) {
            indices.add(node.getCurrentIndex());
            if (children.size() == 1) {
                this.getBaseIndices(node, indices, --depth);
            }
        }
    }

    public void mergeResults(EvaluatorResults evalResult) {
        for (FieldTree ftree : evalResult.getMatchedItems()) {
            this.addMatchedItem(ftree);
        }
        for (Asset asset : evalResult.getMatchedAssets()) {
            this.addMatchedAsset(asset);
        }
    }
}

