/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateRightValue;
import java.util.ArrayList;
import java.util.List;

public class FloatDeterminating
implements IDeterminating {
    private TrePredicate predicate;
    private Field field;

    public FloatDeterminating(TrePredicate predicate, Field field) throws EvaluatorException {
        this.field = field;
        this.predicate = predicate;
    }

    private Float geLhs() throws EvaluatorException {
        if (this.containsUnparsable() || this.field == null) {
            return null;
        }
        return (Float)this.field.getTypedValue();
    }

    private Float getRhsAsFloat() throws EvaluatorException {
        List<Float> list = this.getRhsAsFloatList();
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().getName() + " has a list as a RHS.");
    }

    private List<Float> getRhsAsFloatList() throws EvaluatorException {
        TrePredicateRightValue rightPredicate = (TrePredicateRightValue)this.predicate;
        if (rightPredicate.getValue().size() == 0) {
            throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().getName() + " is missing a RHS.");
        }
        try {
            ArrayList<Float> ints = new ArrayList<Float>();
            for (String predVal : rightPredicate.getValue()) {
                ints.add(Float.valueOf(Float.parseFloat(predVal)));
            }
            return ints;
        }
        catch (NumberFormatException e) {
            throw new EvaluatorException("value must be a Float number", e);
        }
    }

    @Override
    public boolean equal() throws EvaluatorException {
        Float lhs = this.geLhs();
        return lhs != null && lhs.equals(this.getRhsAsFloat());
    }

    @Override
    public boolean greaterThan() throws EvaluatorException {
        Float lhs = this.geLhs();
        return lhs != null && lhs.compareTo(this.getRhsAsFloat()) > 0;
    }

    @Override
    public boolean greaterThanEqual() throws EvaluatorException {
        Float lhs = this.geLhs();
        return lhs != null && lhs.compareTo(this.getRhsAsFloat()) >= 0;
    }

    @Override
    public boolean in() throws EvaluatorException {
        Float lhs = this.geLhs();
        if (lhs == null) {
            return false;
        }
        for (Float compVal : this.getRhsAsFloatList()) {
            if (this.field == null || !lhs.equals(compVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.field == null;
    }

    @Override
    public boolean isNotEmpty() {
        return this.field != null;
    }

    @Override
    public boolean lessThan() throws EvaluatorException {
        Float lhs = this.geLhs();
        return lhs != null && lhs.compareTo(this.getRhsAsFloat()) < 0;
    }

    @Override
    public boolean lessThanEqual() throws EvaluatorException {
        Float lhs = this.geLhs();
        return lhs != null && lhs.compareTo(this.getRhsAsFloat()) <= 0;
    }

    @Override
    public boolean contains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean notEqual() throws EvaluatorException {
        return !this.equal();
    }

    @Override
    public boolean notIn() throws IllegalOperationException, EvaluatorException {
        return !this.in();
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean regex() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean greaterThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lessThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean containsUnparsable() {
        if (this.field == null) {
            return false;
        }
        return this.field.getParsable() == false;
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        throw new IllegalOperationException();
    }
}

