/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.event;

import com.tandbergtv.cms.contentmgmt.service.asset.ITitleSearchService;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.marvin.event.MessageHelper;
import com.tandbergtv.marvin.event.RuleAsyncExecutionException;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpList;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpNode;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreTitleFilter;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleActions;
import com.tandbergtv.watchpoint.pmm.title.search.ISearchCriteriaBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.SearchCriteriaBuilder;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJBException;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

@MessageDriven(name="EventHandlerMDBean", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/EventQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class EventHandlerMDBean
implements MessageListener {
    private static final Logger logger = Logger.getLogger(EventHandlerMDBean.class);
    private static final int MAX_FAILURES_TOLERATED = 25;
    private static final int MAX_TITLES_PER_SEARCH = 5000;
    private static float STATUS_GRANULARITY = 0.1f;
    private QueueConnection queueConnection = null;
    private QueueSession queueSession = null;
    private QueueSession replySession = null;
    @Resource
    private MessageDrivenContext context;
    private ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearch/local", ITitleSearchService.class);
    private IRuleExecutionHandler eventHandler = (IRuleExecutionHandler)InjectionUtil.injectInstance((String)"cms/EventHandler/local", IRuleExecutionHandler.class);
    private IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
    private ITitleService ts = (ITitleService)ServiceRegistry.getDefault().lookup(ITitleService.class);
    private ISearchCriteriaBuilder searchCriteriaBuilder = new SearchCriteriaBuilder();

    @PostConstruct
    public void initialize() {
        QueueConnectionFactory queueFactory = (QueueConnectionFactory)this.context.lookup("ConnectionFactory");
        try {
            this.queueConnection = queueFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(true, 0);
            this.replySession = this.queueConnection.createQueueSession(false, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onMessage(Message message) {
        block10: {
            try {
                String eventType = message.getStringProperty("eventType");
                String packageType = message.getStringProperty("packageType");
                String ruleSetId = message.getStringProperty("ruleSetId");
                String titleId = message.getStringProperty("titleId");
                List<Long> ruleSetIds = MessageHelper.unmarshallList(message.getStringProperty("ruleSetIds"));
                List<Long> titleIds = MessageHelper.unmarshallList(message.getStringProperty("titleIds"));
                Destination returnDestination = message.getJMSReplyTo();
                String correlationId = message.getJMSMessageID();
                ArrayList<Long> failedTitles = new ArrayList<Long>();
                try {
                    this.reply(returnDestination, correlationId, true, "Starting to proccess rules for this request...", 1);
                    logger.info((Object)"Starting to proccess rules for this request...");
                    List<Integer> ruleSets = this.getRulesets(eventType, packageType, ruleSetId, ruleSetIds);
                    if (ruleSets.size() == 0) {
                        logger.warn((Object)"No rule sets to run.");
                        this.reply(returnDestination, correlationId, true, "No rule sets to run.", 100);
                        return;
                    }
                    this.reply(returnDestination, correlationId, true, "Searching for titles...", 2);
                    logger.info((Object)"Searching for titles...");
                    List<Long> titles = this.getTitles(titleId, titleIds, ruleSets);
                    List<List<Long>> splitTitles = this.splitTitleList(titles);
                    int complete = 0;
                    logger.info((Object)("Processing " + (titles == null ? 0 : titles.size()) + " titles..."));
                    for (List<Long> subTitleIds : splitTitles) {
                        int progress;
                        if ((progress = (int)((float)complete++ * STATUS_GRANULARITY * 100.0f)) < 100 && progress > 0) {
                            this.reply(returnDestination, correlationId, true, "processing...", progress);
                        }
                        for (Long tId : subTitleIds) {
                            this.runRules(tId, ruleSets, failedTitles);
                        }
                    }
                    logger.info((Object)"Done!");
                    if (failedTitles.size() != 0) {
                        String failMessage = "FAIL: The following title(s) failed during rule engine execution: " + this.getFailedTitlesString(failedTitles);
                        this.reply(returnDestination, correlationId, false, failMessage, 0);
                        break block10;
                    }
                    this.reply(returnDestination, correlationId, true, "Done!", 100);
                }
                catch (RuleAsyncExecutionException e) {
                    this.reply(returnDestination, correlationId, false, e.getMessage(), 0);
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed execution!", (Throwable)e);
                    this.reply(returnDestination, correlationId, false, "FAIL", 0);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed execution!", (Throwable)e);
            }
        }
    }

    private void runRules(Long titleId, List<Integer> ruleSets, List<Long> failedTitles) throws Exception {
        TransactionManager tm = this.getCurrentTransaction();
        try {
            RuleResults result;
            tm.begin();
            Title title = this.ts.getTitleForUpdate(titleId);
            if (title.getIsActive().booleanValue() && (result = this.eventHandler.runRuler(title, ruleSets)).isModified()) {
                ArrayList<TitleActions> actions = new ArrayList<TitleActions>();
                if (result.ranRuleType("NORMALIZATION")) {
                    actions.add(TitleActions.TITLE_NATIONALIZED_ACTION);
                }
                this.ts.updateAndNotify(result.getTitle(), actions, true, "Rules", null, "sys");
            }
            tm.commit();
        }
        catch (TitlePersistenceException e) {
            this.tryRollback(tm);
            if (e.getCause() instanceof SearchException) {
                String errMsg = "There was a search exception. I hope it was because a title was deleted. Otherwise we might have done something bad.";
                logger.warn((Object)errMsg, (Throwable)e);
            } else {
                this.handleRunRulesException(titleId, (Exception)((Object)e), failedTitles);
            }
        }
        catch (Exception ex) {
            this.tryRollback(tm);
            this.handleRunRulesException(titleId, ex, failedTitles);
        }
    }

    private void handleRunRulesException(Long titleId, Exception e, List<Long> failedTitles) throws RuleAsyncExecutionException {
        failedTitles.add(titleId);
        if (failedTitles.size() >= 25) {
            String msg = "FAIL: Max failures tolerated reached. Failed titles: " + this.getFailedTitlesString(failedTitles);
            throw new RuleAsyncExecutionException(msg, e);
        }
        String msg = "Error while running rules. See stack trace for more info.";
        logger.error((Object)msg, (Throwable)e);
    }

    private String getFailedTitlesString(List<Long> failures) {
        StringBuffer result = new StringBuffer();
        for (Long id : failures) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(id);
        }
        return result.toString();
    }

    private void reply(Destination returnDestination, String correlationId, boolean success, String message, int percent) throws JMSException {
        if (returnDestination != null) {
            MessageProducer messageProducer = this.replySession.createProducer(returnDestination);
            Message returnMessage = this.queueSession.createMessage();
            returnMessage.setObjectProperty("status", (Object)message);
            returnMessage.setIntProperty("percent", percent);
            returnMessage.setBooleanProperty("success", success);
            returnMessage.setJMSCorrelationID(correlationId);
            messageProducer.send(returnMessage);
        }
    }

    private List<Long> getTitles(String titleId, List<Long> titleIds, Collection<Integer> ruleSets) throws Exception {
        if (titleIds != null) {
            return titleIds;
        }
        ArrayList<Long> resultTitleIds = new ArrayList<Long>();
        if (titleId != null) {
            resultTitleIds.add(Long.parseLong(titleId));
        } else {
            int titleCount = this.getTitleCount(ruleSets);
            logger.info((Object)("total titles = " + titleCount));
            int offset = 0;
            while (offset < titleCount) {
                TransactionManager tm = this.getCurrentTransaction();
                try {
                    tm.begin();
                    TreTitleFilter filter = this.buildTitleFilter(ruleSets);
                    filter.setMaxCount(5000);
                    filter.setStartIndex(offset);
                    offset += 5000;
                    if (filter == null) {
                        return new ArrayList<Long>();
                    }
                    SearchCriteria sc = this.searchCriteriaBuilder.buildCriteria(filter);
                    Entity entity = (Entity)sc.getParameter("rootAsset");
                    ArrayList<String> properties = new ArrayList<String>();
                    properties.add("id");
                    entity.setSelectPropertyNames(properties);
                    Collection titles = this.searchService.searchWithLessSecurity(sc);
                    for (Title title : titles) {
                        Long id = title.getId();
                        resultTitleIds.add(id);
                    }
                    logger.info((Object)("loaded titles through " + offset));
                    tm.commit();
                }
                catch (Exception e) {
                    this.tryRollback(tm);
                    throw e;
                }
            }
        }
        logger.info((Object)"finished load titles.");
        return resultTitleIds;
    }

    private int getTitleCount(Collection<Integer> ruleSets) throws Exception {
        TransactionManager tm = this.getCurrentTransaction();
        try {
            tm.begin();
            TreTitleFilter filter = this.buildTitleFilter(ruleSets);
            SearchCriteria sc = this.searchCriteriaBuilder.buildCriteria(filter);
            int count = this.searchService.countWithLessSecurity(sc);
            tm.commit();
            return count;
        }
        catch (Exception e) {
            this.tryRollback(tm);
            throw e;
        }
    }

    private void tryRollback(TransactionManager tm) {
        try {
            tm.rollback();
        }
        catch (Exception ex) {
            logger.warn((Object)"Tried to rollback but was unable to do so.");
        }
    }

    private TreTitleFilter buildTitleFilter(Collection<Integer> ruleSets) {
        TreTitleFilter result = this.buildBlankTitleFilter();
        if (ruleSets.size() == 1) {
            Integer ruleId = ruleSets.iterator().next();
            TreRuleSet rs = this.ruleManager.getRule(ruleId.intValue());
            result = rs.getFilter().hasCriteria() ? rs.getFilter() : this.buildBlankTitleFilter();
        } else {
            TreExpList root = new TreExpList();
            root.setOperator("OR");
            for (Integer ruleId : ruleSets) {
                TreRuleSet rs = this.ruleManager.getRule(ruleId.intValue());
                if (!rs.getEnabled().booleanValue()) continue;
                TreTitleFilter filter = rs.getFilter();
                root.addItem(filter.getRootNode());
                if (filter.hasCriteria()) continue;
                return this.buildBlankTitleFilter();
            }
            result = this.buildBlankTitleFilter();
            result.setRootNode((TreExpNode)root);
        }
        return result;
    }

    private TreTitleFilter buildBlankTitleFilter() {
        TreTitleFilter ttf = new TreTitleFilter();
        ttf.setIsInternalSearch(Boolean.valueOf(true));
        ttf.setIsSearchFieldMetadata(Boolean.valueOf(false));
        ttf.setRootNode(null);
        ttf.setSearchProperty(null);
        ttf.setIsSortFieldMetadata(Boolean.valueOf(false));
        return ttf;
    }

    private List<List<Long>> splitTitleList(List<Long> titles) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int total = titles.size();
        int m = 1;
        int start = 0;
        int end = 0;
        while (true) {
            start = end;
            end = (int)Math.floor((float)total * STATUS_GRANULARITY * (float)m);
            result.add(titles.subList(start, Math.min(end, total)));
            if (end >= total) break;
            ++m;
        }
        return result;
    }

    private List<Integer> getRulesets(String eventType, String packageType, String ruleSetId, List<Long> ruleSetIds) throws RuleAsyncExecutionException {
        Collection<TreRuleSet> ruleSets = this.getRulesetsHelper(eventType, packageType, ruleSetId, ruleSetIds);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (TreRuleSet rs : ruleSets) {
            result.add(rs.getRuleSetId());
        }
        return result;
    }

    private Collection<TreRuleSet> getRulesetsHelper(String eventType, String packageType, String ruleSetId, List<Long> ruleSetIds) throws RuleAsyncExecutionException {
        Collection<Object> result = null;
        if (eventType != null && packageType != null) {
            result = this.ruleManager.getRuleByPackageAndEvent(packageType, eventType);
        } else if (eventType != null) {
            result = this.ruleManager.getRuleByPackageAndEvent("PROCESSING", eventType);
        } else if (packageType != null) {
            result = this.ruleManager.getRulesByPackage(packageType);
        } else if (ruleSetIds != null) {
            result = this.getRuleSetsById(ruleSetIds);
        } else if (ruleSetId != null) {
            result = this.getRuleSetsById(ruleSetId);
        }
        if (result == null) {
            return new ArrayList<TreRuleSet>();
        }
        return result;
    }

    private Collection<TreRuleSet> getRuleSetsById(String ruleSetId) throws RuleAsyncExecutionException {
        try {
            int ruleId = Integer.parseInt(ruleSetId.toString());
            ArrayList<TreRuleSet> ruleSets = new ArrayList<TreRuleSet>();
            TreRuleSet ruleSet = this.ruleManager.getRule(ruleId);
            ruleSets.add(ruleSet);
            return ruleSets;
        }
        catch (EJBException ex) {
            String msg = "Unable to run rule. Rule Set with ID " + ruleSetId + " doesn't exist";
            throw new RuleAsyncExecutionException(msg);
        }
        catch (NumberFormatException ex) {
            String msg = "RuleSetId must be a valid java integer. Value recieved: " + ruleSetId;
            throw new RuleAsyncExecutionException(msg);
        }
    }

    private Collection<TreRuleSet> getRuleSetsById(List<Long> ruleSetIds) throws RuleAsyncExecutionException {
        ArrayList<TreRuleSet> ruleSets = new ArrayList<TreRuleSet>();
        for (Long ruleId : ruleSetIds) {
            try {
                int id = Integer.parseInt(ruleId.toString());
                ruleSets.add(this.ruleManager.getRule(id));
            }
            catch (EJBException ex) {
                String msg = "Unable to run rule. Rule Set with ID " + ruleId + " doesn't exist";
                throw new RuleAsyncExecutionException(msg);
            }
            catch (NumberFormatException ex) {
                String msg = "RuleSetId must be a valid java integer. Value recieved: " + ruleId;
                throw new RuleAsyncExecutionException(msg);
            }
        }
        return ruleSets;
    }

    private TransactionManager getCurrentTransaction() {
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get current transaction manager", (Throwable)e);
        }
        return transactionManager;
    }
}

