/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.metadata;

import com.tandbergtv.marvin.metadata.ActionAnnotations;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarThing {
    public static List<Method> getAnnotatedMethods(Class<Object> class1) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methodArray = methods = class1.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (JarThing.isAnnotatedMethod(method)) {
                list.add(method);
            }
            ++n2;
        }
        return list;
    }

    public static List<Class<Object>> getAnnotatedClasses(String jarlocation) {
        List<String> classNameList = JarThing.getClassNamesFromJar(jarlocation);
        ArrayList<Class<Object>> classList = new ArrayList<Class<Object>>();
        for (String clsname : classNameList) {
            Class<Object> c = JarThing.getClassFromJar(jarlocation, clsname);
            if (!JarThing.isAnnotatedClass(c)) continue;
            classList.add(c);
        }
        return classList;
    }

    public static String getAnnotatedVersion(Class<Object> c) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = c.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ActionAnnotations) {
                return null;
            }
            ++n2;
        }
        return "";
    }

    public static String getAnnotatedName(Method method) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = method.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ActionAnnotations.Action) {
                return ((ActionAnnotations.Action)annotation).name();
            }
            ++n2;
        }
        return "";
    }

    public static boolean isAnnotatedClass(Class<Object> c) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = c.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ActionAnnotations) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAnnotatedMethod(Method method) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = method.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ActionAnnotations.Action) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String printAnnotatedMethod(Method method) {
        StringBuffer s = new StringBuffer();
        Class<?>[] paramTypes = method.getParameterTypes();
        s.append(method.getName());
        if (paramTypes.length > 0) {
            s.append("(");
        }
        int i = 0;
        while (i < paramTypes.length) {
            Class<?> c = paramTypes[i];
            s.append(c.getName());
            if (i < paramTypes.length - 1) {
                s.append(", ");
            }
            ++i;
        }
        if (paramTypes.length > 0) {
            s.append(")");
        }
        return s.toString();
    }

    private static List<String> getClassNamesFromJar(String jarlocation) {
        String classSuffix = ".class";
        ArrayList<String> list = new ArrayList<String>();
        try {
            JarFile jarfile = new JarFile(jarlocation);
            Enumeration<JarEntry> em1 = jarfile.entries();
            while (em1.hasMoreElements()) {
                String entry = em1.nextElement().toString();
                if (!entry.endsWith(classSuffix)) continue;
                String dotted = entry.substring(0, entry.indexOf(classSuffix));
                dotted = dotted.replace('/', '.');
                list.add(dotted);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static Class<Object> getClassFromJar(String pathlocation, String clazz) {
        try {
            URL u = new File(pathlocation).toURI().toURL();
            URLClassLoader cl = new URLClassLoader(new URL[]{u});
            Class<Object> c = Class.forName(clazz, true, cl);
            return c;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String jarlocation = "bin/actions/Actions.jar";
        System.out.println("Hello world");
        List<Class<Object>> annotatedClasses = JarThing.getAnnotatedClasses(jarlocation);
        for (Class<Object> cls : annotatedClasses) {
            System.out.println(JarThing.getAnnotatedVersion(cls));
            System.out.println(cls.getName());
            List<Method> methods = JarThing.getAnnotatedMethods(cls);
            for (Method method : methods) {
                System.out.println("    " + JarThing.printAnnotatedMethod(method));
            }
        }
    }
}

