/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.metadata;

import com.tandbergtv.marvin.metadata.SchemaNode;
import com.tandbergtv.marvin.metadata.SchemaThingHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SchemaThing {
    Map<String, SchemaNode> map;

    public SchemaThing() {
        String path = "/";
        String filepath = String.valueOf(path) + "schema" + File.separator + "TTVSpec.xsd";
        String pkgname = "com.tandbergtv.ttvschema";
        this.populate(filepath, pkgname);
    }

    public SchemaThing(String filepath, String pkgname) {
        this.populate(filepath, pkgname);
    }

    private void populate(String filepath, String pkgname) {
        try {
            SchemaThingHelper sth = new SchemaThingHelper();
            this.map = new TreeMap<String, SchemaNode>();
            this.map.putAll(sth.getMap(filepath, pkgname));
            SchemaNode node = new SchemaNode("TTVSpecComplexType");
            Class<Object> c = Class.forName("com.tandbergtv.ttvschema.TTVSpec");
            node.setMappedClass(c);
            node.setSimpleType(false);
            this.map.put("TTVSpecComplexType", node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getClassMapList() {
        ArrayList<String> list = new ArrayList<String>();
        for (SchemaNode node : this.map.values()) {
            list.add(node.getQName());
        }
        return list;
    }

    public List<String> getComplexSchemaMapList() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> itr = this.map.keySet().iterator();
        while (itr.hasNext()) {
            SchemaNode node = this.map.get(itr.next());
            if (node.isSimpleType()) continue;
            list.add(itr.next());
        }
        return list;
    }

    public List<String> getSimpleSchemaMapList() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> itr = this.map.keySet().iterator();
        while (itr.hasNext()) {
            SchemaNode node = this.map.get(itr.next());
            if (!node.isSimpleType()) continue;
            list.add(node.getQName());
        }
        return list;
    }

    public List<String> getSchemaMapList() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> itr = this.map.keySet().iterator();
        while (itr.hasNext()) {
            list.add(itr.next());
        }
        return list;
    }

    public SchemaNode getSchemaNodeByName(String qname) {
        return this.map.get(qname);
    }

    public SchemaNode getSchemaNodeByObject(Object obj) {
        for (String o : this.map.keySet()) {
            SchemaNode node = this.map.get(o);
            Class<Object> c = node.getMappedClass();
            if (!c.getClass().equals(obj.getClass())) continue;
            return node;
        }
        return null;
    }

    public String getStringBySchemaNode(SchemaNode node) {
        for (String o : this.map.keySet()) {
            if (!this.map.get(o).equals(node)) continue;
            return o;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

