/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.services;

import com.tandbergtv.cms.rules.service.category.EventRetrivalException;
import com.tandbergtv.cms.rules.service.category.IEventManager;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TreRuleSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
public class EventManagerImpl
implements IEventManager {
    @PersistenceContext(unitName="rulesds")
    private EntityManager entityManager;

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public List<TreEvent> getEvents() {
        return this.entityManager.createQuery("select ev FROM TreEvent ev order by eventId").getResultList();
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public TreEvent getEvent(String eventName) throws EventRetrivalException {
        Query query = this.entityManager.createQuery("select ev FROM TreEvent ev WHERE name = :ename");
        query.setParameter("ename", (Object)eventName);
        List events = query.getResultList();
        if (events.size() == 1) {
            return (TreEvent)events.get(0);
        }
        if (events.size() >= 1) {
            throw new EventRetrivalException("There is more than one event with the name: " + eventName);
        }
        throw new EventRetrivalException("There are no events with the name: " + eventName);
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public Set<TreRuleSet> getRulesByEvent(String eventName) throws EventRetrivalException {
        return this.getEvent(eventName).getRules();
    }
}

