/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.services;

import com.tandbergtv.cms.rules.service.category.IPackageManager;
import com.tandbergtv.cms.rules.service.category.PackageRetrievalException;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
public class PackageManagerImpl
implements IPackageManager {
    @PersistenceContext(unitName="rulesds")
    private EntityManager entityManager;

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public List<TrePackage> getPackages() {
        List result = this.entityManager.createQuery("select p FROM TrePackage p ").getResultList();
        return result;
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public List<TrePackage> getPackageByName(String packageName) {
        Query query = this.entityManager.createQuery("select p FROM TrePackage p where name = :packName ");
        query.setParameter("packName", (Object)packageName.toUpperCase());
        return query.getResultList();
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public TrePackage getPackageById(int packageId) {
        Query query = this.entityManager.createQuery("select p FROM TrePackage p where packageId = :packId ");
        query.setParameter("packId", (Object)packageId);
        TrePackage result = (TrePackage)query.getSingleResult();
        return result;
    }

    @RolesAllowed(value={"RulesManagement_Modify"})
    @TransactionAttribute
    public void updatePackage(TrePackage pack) {
        this.entityManager.merge((Object)pack);
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public TrePackage getPackageByNameFirstMatching(String packageName) throws PackageRetrievalException {
        List<TrePackage> results = this.getPackageByName(packageName);
        if (results.size() > 0) {
            return results.get(0);
        }
        throw new PackageRetrievalException("There are no packages with the name: " + packageName);
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public List<TreRuleSet> getRulesByPackage(String packageName) throws PackageRetrievalException {
        return this.getPackageByNameFirstMatching(packageName).getRuleSets();
    }
}

