/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.services;

import com.tandbergtv.cms.rules.service.IRuleService;
import com.tandbergtv.cms.rules.service.RuleDeleteException;
import com.tandbergtv.cms.rules.service.RuleServiceStatus;
import com.tandbergtv.cms.rules.service.category.EventRetrivalException;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.marvin.udt.ShallowRuleSet;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
public class RuleManagerImpl
implements IRuleManager {
    @PersistenceContext(unitName="rulesds")
    private EntityManager entityManager;

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public TreRuleSet getRule(int ruleSetId) {
        Query query = this.entityManager.createQuery("SELECT rs FROM\tTreRuleSet rs WHERE\truleSetId = :rsid");
        query.setParameter("rsid", (Object)ruleSetId);
        TreRuleSet result = (TreRuleSet)query.getSingleResult();
        return result;
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public List<TreRuleSet> getRuleSets(List<Integer> ruleSetIds) {
        if (ruleSetIds == null || ruleSetIds.size() == 0) {
            return new ArrayList<TreRuleSet>();
        }
        StringBuffer str = new StringBuffer();
        str.append("SELECT rs ");
        str.append("FROM\tTreRuleSet rs ");
        str.append("WHERE\truleSetId IN (");
        int i = 0;
        while (i < ruleSetIds.size()) {
            if (i > 0) {
                str.append(",");
            }
            str.append(":rsid" + i);
            ++i;
        }
        str.append(")");
        Query query = this.entityManager.createQuery(str.toString());
        int i2 = 0;
        while (i2 < ruleSetIds.size()) {
            query.setParameter("rsid" + i2, (Object)ruleSetIds.get(i2));
            ++i2;
        }
        List result = query.getResultList();
        return result;
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public List<TreRuleSet> getRulesByPackage(String packageName) {
        String queryString = "SELECT tr FROM\t TrePackage p JOIN\t p.ruleSets tr WHERE  p.name = :pname order by tr.order_";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("pname", (Object)packageName);
        List result = query.getResultList();
        return result;
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public List<TreRuleSet> getRulesByEvent(String eventName) throws EventRetrivalException {
        String queryString = "SELECT tr FROM\t TreEvent e JOIN\t e.rules tr WHERE\t e.name = :ename ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("ename", (Object)eventName);
        List result = query.getResultList();
        return result;
    }

    @RolesAllowed(value={"RulesManagement_Create, RulesManagement_Modify"})
    @TransactionAttribute
    public void saveRule(TreRuleSet rule) {
        this.entityManager.persist((Object)rule);
    }

    @RolesAllowed(value={"RulesManagement_Modify"})
    @TransactionAttribute
    public void updateRule(TreRuleSet rule) {
        this.entityManager.merge((Object)rule);
    }

    @RolesAllowed(value={"RulesManagement_Delete"})
    @TransactionAttribute
    public void deleteRuleSet(TreRuleSet ruleSet) throws RuleDeleteException {
        List<RuleServiceStatus> reasons = this.checkIfCanDelete(ruleSet.getRuleSetId());
        if (reasons.size() > 0) {
            throw new RuleDeleteException(reasons);
        }
        if (ruleSet != null) {
            TrePackage tpack = ruleSet.getTpackage();
            tpack.getRuleSets().remove(ruleSet);
        }
    }

    @RolesAllowed(value={"RulesManagement_Delete"})
    @TransactionAttribute
    public void deleteRuleSet(int ruleSetId) throws RuleDeleteException {
        TreRuleSet ruleSet = (TreRuleSet)this.entityManager.find(TreRuleSet.class, (Object)ruleSetId);
        this.deleteRuleSet(ruleSet);
    }

    @RolesAllowed(value={"RulesManagement_View"})
    @TransactionAttribute
    public List<TreRuleSet> getRuleByPackageAndEvent(String packageName, String eventName) {
        String queryString = "SELECT tr FROM\tTreEvent e JOIN\te.rules tr JOIN\ttr.tpackage p WHERE p.name = :pname AND\te.name = :ename order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("pname", (Object)packageName);
        query.setParameter("ename", (Object)eventName);
        List result = query.getResultList();
        return result;
    }

    @RolesAllowed(value={"RulesManagement_Delete"})
    @TransactionAttribute
    public void deleteRuleSets(List<Integer> ruleSetIds) throws RuleDeleteException {
        ArrayList<RuleServiceStatus> blockers = new ArrayList<RuleServiceStatus>();
        for (Integer id : ruleSetIds) {
            List<RuleServiceStatus> reasons = this.checkIfCanDelete(id);
            blockers.addAll(reasons);
        }
        if (blockers.size() > 0) {
            throw new RuleDeleteException(blockers);
        }
        for (Integer id : ruleSetIds) {
            this.deleteRuleSetHelper(id);
        }
    }

    @RolesAllowed(value={"RulesManagement_View"})
    public List<ShallowRuleSet> getShallowRuleSets(String eventName) {
        String queryString = "SELECT new com.tandbergtv.marvin.udt.ShallowRuleSet(tr.ruleSetId, tr.ruleName, p.name)FROM\tTreEvent e JOIN\te.rules tr JOIN\ttr.tpackage p WHERE e.name = :ename order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("ename", (Object)eventName);
        List result = query.getResultList();
        return result;
    }

    private List<RuleServiceStatus> checkIfCanDelete(int ruleSetId) {
        ServiceLoader<IRuleService> services = ServiceLoader.load(IRuleService.class);
        ArrayList<RuleServiceStatus> reasons = new ArrayList<RuleServiceStatus>();
        for (IRuleService service : services) {
            RuleServiceStatus serviceStatus = service.canDelete((long)ruleSetId);
            if (serviceStatus.canProceed()) continue;
            reasons.add(serviceStatus);
        }
        return reasons;
    }

    @TransactionAttribute
    private void deleteRuleSetHelper(int ruleSetId) {
        TreRuleSet ruleSet = (TreRuleSet)this.entityManager.find(TreRuleSet.class, (Object)ruleSetId);
        if (ruleSet != null) {
            TrePackage tpack = ruleSet.getTpackage();
            tpack.getRuleSets().remove(ruleSet);
        }
    }
}

