/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.udt;

import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="genericType")
public class GenericType
implements Serializable {
    private static final long serialVersionUID = -6251125422043941767L;
    private String stringValue;
    private long longValue;
    private float floatValue;
    private Date dateValue;
    private String timeValue;
    private boolean booleanValue;
    private DataTypes dataType;

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
        this.dataType = DataTypes.STRING;
    }

    @XmlElement(nillable=true)
    public String getStringValue() {
        return this.stringValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
        this.dataType = DataTypes.LONG;
    }

    @XmlElement(nillable=true)
    public long getLongValue() {
        return this.longValue;
    }

    public void setFloatValue(float floatValue) {
        this.floatValue = floatValue;
        this.dataType = DataTypes.FLOAT;
    }

    @XmlElement(nillable=true)
    public float getFloatValue() {
        return this.floatValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
        this.dataType = DataTypes.DATE;
    }

    @XmlElement(nillable=true)
    public Date getDateValue() {
        return this.dateValue;
    }

    public void setTimeValue(String timeValue) {
        this.timeValue = timeValue;
        this.dataType = DataTypes.TIME;
    }

    @XmlElement(nillable=true)
    public String getTimeValue() {
        return this.timeValue;
    }

    @XmlElement(nillable=true)
    public DataTypes getDataType() {
        return this.dataType;
    }

    public void setBooleanValue(boolean booleanValue) {
        this.booleanValue = booleanValue;
        this.dataType = DataTypes.BOOLEAN;
    }

    @XmlElement(nillable=true)
    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    @XmlElement(nillable=true)
    public Object getTypedObject() {
        switch (this.dataType) {
            case LONG: {
                return this.longValue;
            }
            case FLOAT: {
                return Float.valueOf(this.floatValue);
            }
            case BOOLEAN: {
                return this.booleanValue;
            }
            case DATE: {
                return this.dateValue;
            }
            case TIME: {
                return this.timeValue;
            }
            case STRING: {
                return this.stringValue;
            }
        }
        return null;
    }

    @XmlEnum
    public static enum DataTypes {
        LONG("integer"),
        FLOAT("float"),
        BOOLEAN("boolean"),
        STRING("string"),
        DATE("date"),
        TIME("time"),
        NULL("");

        private String name;

        private DataTypes(String name) {
            this.name = name;
        }

        public String getDataTypeName() {
            return this.name;
        }

        public String value() {
            return this.name;
        }

        public static DataTypes fromValue(String name) {
            for (DataTypes c : DataTypes.values()) {
                if (!c.value().equals(name)) continue;
                return c;
            }
            throw new IllegalArgumentException(name);
        }
    }
}

