/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesTabContainer;
import com.tandbergtv.cms.rules.ui.client.common.events.RulesClearEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.TabChangeEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.TabChangeHandler;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RulesListingPanel;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class RulesTab
implements WidgetFactory {
    private RulesTabContainer panel;
    private Packages pkg;

    public RulesTab(Packages pkg) {
        this.pkg = pkg;
        this.panel = new RulesTabContainer();
    }

    public Widget getInstance() {
        this.panel.clear();
        RulesComponent component = RulesComponent.getInstance();
        if (!component.isReady()) {
            return this.getUnreadyBox();
        }
        if (component.hasErrors()) {
            return this.getErrorsBox();
        }
        Panel source = (Panel)this.panel.getContents();
        RulesListingPanel target = new RulesListingPanel(this.pkg);
        TabChangeEvent event = new TabChangeEvent(this.pkg, source, (Panel)target);
        HandlerManager hman = component.getHandlerManager();
        hman.fireEvent((GwtEvent)event);
        return this.panel;
    }

    public void addHandler(TabChangeHandler handler) {
        RulesComponent component = RulesComponent.getInstance();
        HandlerManager hman = component.getHandlerManager();
        hman.addHandler(TabChangeEvent.TYPE, (EventHandler)handler);
    }

    public void release(Widget widget) {
    }

    public void setContents(Widget widget) {
        this.panel.add(widget);
        RulesClearEvent e = new RulesClearEvent();
        RulesComponent component = RulesComponent.getInstance();
        HandlerManager hman = component.getHandlerManager();
        hman.fireEvent((GwtEvent)e);
    }

    public Widget getTabContents() {
        return this.panel.getContents();
    }

    private VerticalContainer getUnreadyBox() {
        VerticalContainer box = new VerticalContainer();
        String msg = "Rules Component is not ready. Specification is not yet loaded";
        LabelWidget label = new LabelWidget(msg);
        box.add((Widget)label);
        this.panel.add((Widget)box);
        this.retrySpecificationLoad();
        return this.panel;
    }

    private VerticalContainer getErrorsBox() {
        VerticalContainer box = new VerticalContainer();
        String msg = "Rules Component has errors loading";
        LabelWidget label = new LabelWidget(msg);
        box.add((Widget)label);
        this.panel.add((Widget)box);
        return this.panel;
    }

    private void retrySpecificationLoad() {
        Timer timer = new Timer(){

            public void run() {
                if (!RulesComponent.getInstance().isReady()) {
                    RulesComponent.getInstance().loadSpecification();
                }
            }
        };
        timer.schedule(5000);
    }
}

