/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class RuleButtonPanel
extends HorizontalContainer {
    private ButtonWidget saveButton;
    private ButtonWidget cancelButton;
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);

    public RuleButtonPanel(boolean isNewRule) {
        this.saveButton = this.createSaveButton();
        this.cancelButton = this.createCancelButton();
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        if (security.isUserInRole(Permissions.MODIFY) || isNewRule && security.isUserInRole(Permissions.CREATE)) {
            this.add((Widget)this.saveButton);
        }
        this.add((Widget)this.cancelButton);
    }

    private ButtonWidget createCancelButton() {
        ButtonWidget button = new ButtonWidget(this.myConstants.cancel());
        button.addStyleDependentName("dataloss-button");
        return button;
    }

    private ButtonWidget createSaveButton() {
        ButtonWidget button = new ButtonWidget(this.myConstants.save());
        button.addStyleDependentName("commit-button");
        return button;
    }

    public void addButton(ButtonWidget button) {
        this.add((Widget)button);
    }

    public void setSaveClickHandler(ClickHandler handler) {
        this.saveButton.addClickHandler(handler);
    }

    public void setCancelClickHandler(ClickHandler handler) {
        this.cancelButton.addClickHandler(handler);
    }
}

