/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.data.UIRule;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRule;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class NormalizationRulePanel
extends VerticalContainer
implements Validatable {
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    protected List<NormalizationRule> rules = new ArrayList<NormalizationRule>();
    private VerticalContainer warningMessages = new VerticalContainer();
    private VerticalContainer rulesContainer = new VerticalContainer();
    private boolean reorderEnabled;
    private ButtonWidget reorderButton;

    public NormalizationRulePanel(List<UIRule> rules) {
        this.buildUi(rules);
    }

    public List<UIRule> getRules() {
        ArrayList<UIRule> result = new ArrayList<UIRule>();
        for (NormalizationRule rule : this.rules) {
            UIRule newRule = rule.getRule();
            if (newRule == null) continue;
            result.add(newRule);
        }
        return result;
    }

    private void buildUi(List<UIRule> uirules) {
        this.add((Widget)this.warningMessages);
        this.add((Widget)this.rulesContainer);
        this.add(this.buildButtons());
        for (UIRule rule : uirules) {
            NormalizationRule widgRule = new NormalizationRule(rule, this, this.rules.size());
            this.rulesContainer.add((Widget)widgRule);
            this.rules.add(widgRule);
        }
    }

    public void removeRuleFromContainer(NormalizationRule rule) {
        int ruleIndex = rule.getIndex();
        this.rulesContainer.remove((Widget)rule);
        this.rules.remove((Object)rule);
        if (ruleIndex < this.rules.size()) {
            ListIterator<NormalizationRule> iterator = this.rules.listIterator(ruleIndex);
            while (iterator.hasNext()) {
                int index = iterator.nextIndex();
                iterator.next().setCurrentIndex(index);
            }
        }
    }

    public boolean validate() {
        boolean result = true;
        for (NormalizationRule rule : this.rules) {
            if (rule.validate()) continue;
            result = false;
        }
        return result;
    }

    private Widget buildButtons() {
        HorizontalContainer container = new HorizontalContainer();
        container.add((Widget)this.buildReorderButton());
        container.add((Widget)this.createButton(this.myConstants.createRuleButtonLabel()));
        return container;
    }

    private ButtonWidget buildReorderButton() {
        this.reorderEnabled = false;
        this.reorderButton = new ButtonWidget(this.myConstants.enableReorder(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRulePanel.this.reorderEnabled = !NormalizationRulePanel.this.reorderEnabled;
                String text = NormalizationRulePanel.this.reorderEnabled ? NormalizationRulePanel.this.myConstants.disableReorder() : NormalizationRulePanel.this.myConstants.enableReorder();
                NormalizationRulePanel.this.reorderButton.setText(text);
                for (NormalizationRule rule : NormalizationRulePanel.this.rules) {
                    rule.enableReorder(NormalizationRulePanel.this.reorderEnabled);
                }
            }
        });
        this.reorderButton.addStyleDependentName("action-button");
        this.reorderButton.addStyleName("rule-createRuleButton");
        return this.reorderButton;
    }

    private ButtonWidget createButton(String buttonName) {
        ButtonWidget button = new ButtonWidget(buttonName, new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRule panel = new NormalizationRule(NormalizationRulePanel.this, NormalizationRulePanel.this.rules.size());
                NormalizationRulePanel.this.rulesContainer.add((Widget)panel);
                NormalizationRulePanel.this.rules.add(panel);
            }
        });
        button.addStyleDependentName("action-button");
        button.addStyleName("rule-createRuleButton");
        return button;
    }

    public void reorder(NormalizationRule rule, int newPos) {
        if (newPos == rule.getIndex()) {
            return;
        }
        if (newPos < 0) {
            newPos = 0;
        } else if (newPos > this.rules.size() - 1) {
            newPos = this.rules.size() - 1;
        }
        this.rules.remove(rule.getIndex());
        this.rules.add(newPos, rule);
        int containerPos = newPos;
        if (newPos > rule.getIndex()) {
            ++containerPos;
        }
        this.rulesContainer.insert((Widget)rule, containerPos);
        int i = rule.getIndex() < newPos ? rule.getIndex() : newPos;
        while (i < this.rules.size()) {
            this.rules.get(i).setCurrentIndex(i);
            ++i;
        }
    }

    public boolean isReorderEnabled() {
        return this.reorderEnabled;
    }
}

