/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.validation;

import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRowBase;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.ParamType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.SearchOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterComplexValue;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import java.util.ArrayList;
import java.util.List;

public class RulePanelHelper {
    public static void populateTree(UITitleFilterListNode list, PredicateList row) {
        TitleFilterOperator op = row.getOperator() == PredicateList.OP_AND ? TitleFilterOperator.AND : TitleFilterOperator.OR;
        list.setUiRetOperator(op);
        for (PredicateRowBase predNode : row.getChildRowNodes()) {
            if (predNode instanceof PredicateRow) {
                PredicateRow validationRow = (PredicateRow)predNode;
                if (validationRow.isDeleted() || !validationRow.hasContents()) continue;
                UITitleFilterValueNode valueNode = RulePanelHelper.createUiPredicate(validationRow);
                String sectionType = validationRow.getXmlTreeObject().getAssetType();
                valueNode.setSectionType(sectionType);
                list.addItem((IUITitleFilterNode)valueNode);
                continue;
            }
            if (!(predNode instanceof PredicateList)) continue;
            PredicateList cl = (PredicateList)predNode;
            UITitleFilterListNode childList = new UITitleFilterListNode();
            RulePanelHelper.populateTree(childList, cl);
            if (childList.isEmpty()) continue;
            list.addItem((IUITitleFilterNode)childList);
        }
    }

    private static UITitleFilterValueNode createUiPredicate(PredicateRow row) {
        String xml = row.getXmlTreeObject().getXpath();
        String sectionType = row.getXmlTreeObject().getAssetType();
        SearchOperator op = (SearchOperator)row.getOperatorList().getSelectedItem();
        List value = row.getValue();
        ParamType paramType = row.getParamType();
        UITitleFilterValueNode pred = null;
        if (op == RulesOperator.EVALCHILDFIELDS) {
            ArrayList<UITitleFilterValueNode> children = new ArrayList<UITitleFilterValueNode>();
            for (PredicateRowBase r : row.getChildRowNodes()) {
                PredicateRow evalRow;
                if (!(r instanceof PredicateRow) || (evalRow = (PredicateRow)r).isDeleted()) continue;
                children.add(RulePanelHelper.createUiPredicate(evalRow));
            }
            pred = new UITitleFilterComplexValue(xml, sectionType, op, value, paramType, children);
        } else {
            pred = new UITitleFilterValueNode(xml, sectionType, op, value, paramType, row.isIgnoreCase());
        }
        return pred;
    }

    public static UITitleFilter getTitleFilterPanel(TitleFilterPanel panelFilter) {
        UITitleFilter filter = new UITitleFilter();
        UITitleFilterListNode tree = new UITitleFilterListNode();
        if (panelFilter.getDataList().isVisible()) {
            RulePanelHelper.populateTree(tree, panelFilter.getDataList());
        }
        filter.setRootNode((IUITitleFilterNode)tree);
        return filter;
    }
}

