/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.validation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.UiButtonService;
import com.tandbergtv.cms.rules.ui.client.UiButtonServiceAsync;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.EventSelectPanel;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanelFactory;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRulePanel;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationCriteriaPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Date;
import java.util.List;

public class ValidationTestPanel
extends VerticalContainer {
    private VerticalContainer resultsPanel = new VerticalContainer();
    private VerticalContainer contentsPanel = new VerticalContainer();
    private UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);
    private LabelWidget messageBox = new LabelWidget();
    private FlexTableContainer table = new FlexTableContainer();
    private Packages pkgType = Packages.NORMALIZATION;
    private final UiButtonServiceAsync buttonService = (UiButtonServiceAsync)GWT.create(UiButtonService.class);
    private final int HEADER_ROW = 0;
    private final int ID_COL = 0;
    private final int NAME_COL = 1;
    private final int EVENT_COL = 2;
    private final int TITLE_COL = 3;
    private final int CRIT_COL = 4;

    public ValidationTestPanel() {
        HorizontalContainer buttonPanel = new HorizontalContainer();
        buttonPanel.add((Widget)this.createTestButton());
        buttonPanel.add((Widget)this.createClearButton());
        this.table.setWidth("800px");
        this.table.setText(0, 0, "ID");
        this.table.setText(0, 1, "Name");
        this.table.setText(0, 2, "Event");
        this.table.setText(0, 3, "Title Filter");
        this.table.setText(0, 4, "Criteria");
        this.add((Widget)buttonPanel);
        this.add((Widget)this.resultsPanel);
        this.add((Widget)new LabelWidget("TEST"));
        this.add((Widget)this.messageBox);
        this.add((Widget)this.table);
        this.add((Widget)this.contentsPanel);
        this.rulesService.getRuleSetsByPackage(this.pkgType.toString(), (AsyncCallback<List<UIRuleListItem>>)this.getDataRetrieveCallback());
    }

    private ButtonWidget createTestButton() {
        ButtonWidget button = new ButtonWidget("Test");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValidationTestPanel.this.buttonService.runButtonator((AsyncCallback<List<String>>)ValidationTestPanel.this.createAsyncCallback());
            }
        });
        return button;
    }

    private ButtonWidget createClearButton() {
        ButtonWidget button = new ButtonWidget("Clean");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValidationTestPanel.this.resultsPanel.clear();
            }
        });
        return button;
    }

    private NeptuneAsyncCallback<List<String>> createAsyncCallback() {
        return new NeptuneAsyncCallback<List<String>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)(caught == null ? "FAIL" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<String> result) {
                ValidationTestPanel.this.addResults(result);
            }
        };
    }

    public void addResults(List<String> results) {
        this.resultsPanel.clear();
        this.resultsPanel.add((Widget)new LabelWidget("RAN TEST: " + new Date()));
        for (String result : results) {
            TextAreaWidget ta = new TextAreaWidget();
            ta.setText(result);
            ta.setCharacterWidth(80);
            ta.setVisibleLines(10);
            this.resultsPanel.add((Widget)ta);
        }
        this.resultsPanel.add((Widget)new LabelWidget("-- RESULTS END -- "));
    }

    private NeptuneAsyncCallback<List<UIRuleListItem>> getDataRetrieveCallback() {
        return new NeptuneAsyncCallback<List<UIRuleListItem>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<UIRuleListItem> result) {
                int i = 1;
                while (i < result.size()) {
                    UIRuleListItem item = result.get(i);
                    HTMLWidget id = new HTMLWidget("" + item.getId());
                    HTMLWidget name = new HTMLWidget(item.getName());
                    HTMLWidget event = new HTMLWidget("x");
                    HTMLWidget title = new HTMLWidget("x");
                    HTMLWidget crit = new HTMLWidget("x");
                    id.addClickHandler(ValidationTestPanel.this.getHDetail(item.getId(), 0));
                    name.addClickHandler(ValidationTestPanel.this.getHDetail(item.getId(), 1));
                    event.addClickHandler(ValidationTestPanel.this.getHDetail(item.getId(), 2));
                    title.addClickHandler(ValidationTestPanel.this.getHDetail(item.getId(), 3));
                    crit.addClickHandler(ValidationTestPanel.this.getHDetail(item.getId(), 4));
                    id.setStyleName("table-data-link");
                    name.setStyleName("table-data-link");
                    event.setStyleName("table-data-link");
                    title.setStyleName("table-data-link");
                    crit.setStyleName("table-data-link");
                    ValidationTestPanel.this.table.getRowFormatter().setStyleName(i, "table-data-odd-row");
                    ValidationTestPanel.this.table.setWidget(i, 0, (Widget)id);
                    ValidationTestPanel.this.table.setWidget(i, 1, (Widget)name);
                    ValidationTestPanel.this.table.setWidget(i, 2, (Widget)event);
                    ValidationTestPanel.this.table.setWidget(i, 3, (Widget)title);
                    ValidationTestPanel.this.table.setWidget(i, 4, (Widget)crit);
                    ++i;
                }
            }
        };
    }

    private ClickHandler getHDetail(final int ruleSetId, final int col) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValidationTestPanel.this.contentsPanel.clear();
                ValidationTestPanel.this.rulesService.getRuleSet(ruleSetId, (AsyncCallback<UIRuleSet>)ValidationTestPanel.this.getRulesFetchCallback(col));
            }
        };
    }

    private AsyncCallback<UIRuleSet> getRulesFetchCallback(final int col) {
        return new AsyncCallback<UIRuleSet>(){

            public void onFailure(Throwable caught) {
                ValidationTestPanel.this.messageBox.setText("Error Loading Ruleset");
            }

            public void onSuccess(UIRuleSet result) {
                Panel panel = ValidationTestPanel.this.getPanel(col, result);
                ValidationTestPanel.this.contentsPanel.add((Widget)panel);
            }
        };
    }

    private Panel getPanel(int col, UIRuleSet result) {
        switch (col) {
            case 0: {
                RulePanel rulePanel = RulePanelFactory.create(this.pkgType);
                rulePanel.setRule(result);
                return rulePanel;
            }
            case 1: {
                return new RuleNamePanel(result.getName(), true);
            }
            case 2: {
                return new EventSelectPanel(result);
            }
            case 3: {
                return new TitleFilterPanel(result);
            }
            case 4: {
                return this.pkgType == Packages.NORMALIZATION ? new NormalizationRulePanel(result.getRules()) : new ValidationCriteriaPanel(result);
            }
        }
        return null;
    }
}

