/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.timers;

import com.ericsson.cms.scheduler.ScheduleTime;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.timers.TimerHelper;
import com.tandbergtv.watchpoint.pmm.job.ui.JobUIConstants;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class OnDate {
    private static final Logger logger = Logger.getLogger(OnDate.class);

    public static ScheduleTime getTime(ScheduleRule rule) {
        String jobDate = rule.getParam(1).getValue();
        String jobTime = rule.getParam(2).getValue();
        if (jobDate == null) {
            logger.error((Object)"Job date not specified.");
            return null;
        }
        try {
            SimpleDateFormat sf = new SimpleDateFormat(JobUIConstants.JOB_RULE_DATE_FORMAT);
            sf.setLenient(false);
            Date jDate = sf.parse(jobDate);
            Date jobStartDate = TimerHelper.getStartDateTime(jDate, jobTime);
            return new ScheduleTime(jobStartDate);
        }
        catch (ParseException e) {
            logger.error((Object)("Error while getting time: " + e.toString()));
            return null;
        }
    }
}

