/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.timers;

import com.ericsson.cms.scheduler.ScheduleTime;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.timers.EveryNWeeks;
import com.tandbergtv.watchpoint.pmm.job.util.Day;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class OnDayEveryNWeeks {
    private static final Logger logger = Logger.getLogger(OnDayEveryNWeeks.class);
    public static String DATE_FORMAT = "EEE MMM dd HH:mm:ss z yyyy";

    public static ScheduleTime getTime(ScheduleRule rule) {
        String day = rule.getParam(1).getValue();
        String numberOfWeeks = rule.getParam(2).getValue();
        String jobTime = rule.getParam(3).getValue();
        logger.debug((Object)("Initial job start date: " + rule.getStartDate()));
        Date jobStartDate = OnDayEveryNWeeks.getClosestDay(rule.getStartDate(), day);
        logger.debug((Object)("Setting job start date to: " + jobStartDate.toString()));
        return EveryNWeeks.getTime(jobStartDate, jobTime, numberOfWeeks, rule.getEndDate());
    }

    private static Date getClosestDay(Date startDate, String day) {
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        int startDay = c.get(7);
        int d = Day.valueOf((String)day).ordinal() + 1;
        if (startDay == d) {
            return startDate;
        }
        while (startDay != d) {
            c.add(5, 1);
            startDay = c.get(7);
        }
        return c.getTime();
    }
}

