/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_01_Generate_Metadata {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    private static final String UID = "01CM01";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        titleId = utilApi.createTitleForMetadata();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptySpec() throws Exception {
        logger.debug((Object)("Test_01_Generate_Metadata - Inside testEmptySpec TitleId: " + titleId));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        String ouputMetadataFilePath = "/opt/tandbergtv/cms/workflow/lib/content-management-template/DummyDepricated.xml";
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("spec", "");
        this.params.put("outputMetadataFilePath", ouputMetadataFilePath);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_01_Generate_Metadata testEmptySpec - Success : " + this.response.get("result")));
        logger.debug((Object)("Test_01_Generate_Metadata testEmptySpec - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("result"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInValidSpec() throws Exception {
        logger.debug((Object)("Test_01_Generate_Metadata - Inside testInValidSpec TitleId: " + titleId));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        String ouputMetadataFilePath = "/opt/tandbergtv/cms/workflow/lib/content-management-template/DummyDepricated.xml";
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("spec", "Xyz45");
        this.params.put("outputMetadataFilePath", ouputMetadataFilePath);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_01_Generate_Metadata testInValidSpec - Success : " + this.response.get("result")));
        logger.debug((Object)("Test_01_Generate_Metadata testInValidSpec - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("result"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyOMDPath() throws Exception {
        logger.debug((Object)("Test_01_Generate_Metadata - Inside testEmptyOMDPath TitleId: " + titleId));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        String ouputMetadataFilePath = " ";
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("spec", "CL1_1");
        this.params.put("outputMetadataFilePath", ouputMetadataFilePath);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_01_Generate_Metadata testEmptyOMDPath - Success : " + this.response.get("result")));
        logger.debug((Object)("Test_01_Generate_Metadata testEmptyOMDPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("result"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInValidOMDPath() throws Exception {
        logger.debug((Object)("Test_01_Generate_Metadata - Inside testInValidOMDPath TitleId: " + titleId));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        String ouputMetadataFilePath = "Xyz/lmn/abdc1234";
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("spec", "CL1_1");
        this.params.put("outputMetadataFilePath", ouputMetadataFilePath);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_01_Generate_Metadata testInValidOMDPath - Success : " + this.response.get("result")));
        logger.debug((Object)("Test_01_Generate_Metadata testInValidOMDPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("result"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        String ouputMetadataFilePath = "/opt/tandbergtv/cms/workflow/lib/content-management-template/DummyDepricated.xml";
        this.params.put("titleId", "");
        this.params.put("spec", "CL1_1");
        this.params.put("outputMetadataFilePath", ouputMetadataFilePath);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_01_Generate_Metadata testEmptyTitleId - Success : " + this.response.get("result")));
        logger.debug((Object)("Test_01_Generate_Metadata testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("result"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        String ouputMetadataFilePath = "/opt/tandbergtv/cms/workflow/lib/content-management-template/DummyDepricated.xml";
        this.params.put("titleId", "-1");
        this.params.put("spec", "CL1_1");
        this.params.put("outputMetadataFilePath", ouputMetadataFilePath);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_01_Generate_Metadata testNegativeTitleId - Success : " + this.response.get("result")));
        logger.debug((Object)("Test_01_Generate_Metadata testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("result"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        String ouputMetadataFilePath = "/opt/tandbergtv/cms/workflow/lib/content-management-template/DummyDepricated.xml";
        this.params.put("titleId", "abcd");
        this.params.put("spec", "CL1_1");
        this.params.put("outputMetadataFilePath", ouputMetadataFilePath);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_01_Generate_Metadata testStringAsTitleId - Success : " + this.response.get("result")));
        logger.debug((Object)("Test_01_Generate_Metadata testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("result"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171381";
        logger = Logger.getLogger(Test_01_Generate_Metadata.class);
    }
}

