/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_52_Generate_URL_for_Title_Asset_Mapping {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    static int assetId;
    static String assetType;
    private static final String UID = "01CM02";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
        assetId = utilApi.getAssetId(titleId, assetType);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("listOfAssetIds", String.valueOf(assetId));
        logger.debug((Object)"Test_52_Generate_URL_for_Title_Asset_Mapping testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("listOfAssetIds")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testEmptyTitleId - urlForTitleAssetMapping : " + this.response.get("urlForTitleAssetMapping")));
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("urlForTitleAssetMapping"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("listOfAssetIds", String.valueOf(assetId));
        logger.debug((Object)"Test_52_Generate_URL_for_Title_Asset_Mapping testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("listOfAssetIds")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testNegativeTitleId - urlForTitleAssetMapping : " + this.response.get("urlForTitleAssetMapping")));
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("urlForTitleAssetMapping"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("listOfAssetIds", String.valueOf(assetId));
        logger.debug((Object)"Test_52_Generate_URL_for_Title_Asset_Mapping testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("listOfAssetIds")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testStringAsTitleId - urlForTitleAssetMapping : " + this.response.get("urlForTitleAssetMapping")));
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("urlForTitleAssetMapping"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyListOfAssetIds() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("listOfAssetIds", "");
        logger.debug((Object)"Test_52_Generate_URL_for_Title_Asset_Mapping testEmptyListOfAssetIds Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " ListOfAssetIds -> " + this.params.get("listOfAssetIds")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testEmptyListOfAssetIds - urlForTitleAssetMapping : " + this.response.get("urlForTitleAssetMapping")));
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testEmptyListOfAssetIds - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("urlForTitleAssetMapping"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeListOfAssetIds() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("listOfAssetIds", "-1");
        logger.debug((Object)"Test_52_Generate_URL_for_Title_Asset_Mapping testNegativeListOfAssetIds Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " ListOfAssetIds -> " + this.params.get("listOfAssetIds")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testNegativeListOfAssetIds - urlForTitleAssetMapping : " + this.response.get("urlForTitleAssetMapping")));
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testNegativeListOfAssetIds - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("urlForTitleAssetMapping"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsListOfAssetIds() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("listOfAssetIds", "abcd");
        logger.debug((Object)"Test_52_Generate_URL_for_Title_Asset_Mapping testStringAsListOfAssetIds Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " ListOfAssetIds -> " + this.params.get("listOfAssetIds")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testStringAsListOfAssetIds - urlForTitleAssetMapping : " + this.response.get("urlForTitleAssetMapping")));
        logger.debug((Object)("Test_52_Generate_URL_for_Title_Asset_Mapping testStringAsListOfAssetIds - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("urlForTitleAssetMapping"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        assetType = "POSTER";
        logger = Logger.getLogger(Test_52_Generate_URL_for_Title_Asset_Mapping.class);
    }
}

