/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_54_Add_Title_Progress {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    private static final String STATUS = "Movie Recieved";
    private static final String SUCCESS = "true";
    private static final String UID = "01CM54";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("status", STATUS);
        this.params.put("success", SUCCESS);
        logger.debug((Object)"Test_54_Add_Title_Progress testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Status -> " + this.params.get("status") + " Success -> " + this.params.get("success")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_54_Add_Title_Progress testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("status", STATUS);
        this.params.put("success", SUCCESS);
        logger.debug((Object)"Test_54_Add_Title_Progress testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Status -> " + this.params.get("status") + " Success -> " + this.params.get("success")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_54_Add_Title_Progress testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("status", STATUS);
        this.params.put("success", SUCCESS);
        logger.debug((Object)"Test_54_Add_Title_Progress testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Status -> " + this.params.get("status") + " Success -> " + this.params.get("success")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_54_Add_Title_Progress testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyStatus() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("status", "");
        this.params.put("success", SUCCESS);
        logger.debug((Object)"Test_54_Add_Title_Progress testEmptyStatus Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Status -> " + this.params.get("status") + " Success -> " + this.params.get("success")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_54_Add_Title_Progress testEmptyStatus - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptySuccess() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("status", STATUS);
        this.params.put("success", "");
        logger.debug((Object)"Test_54_Add_Title_Progress testEmptySuccess Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Status -> " + this.params.get("status") + " Success -> " + this.params.get("success")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_54_Add_Title_Progress testEmptySuccess - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidSuccess() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("status", STATUS);
        this.params.put("success", "abcd");
        logger.debug((Object)"Test_54_Add_Title_Progress testInvalidSuccess Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Status -> " + this.params.get("status") + " Success -> " + this.params.get("success")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_54_Add_Title_Progress testInvalidSuccess - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        logger = Logger.getLogger(Test_54_Add_Title_Progress.class);
    }
}

