/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_57_Get_Asset_Metadata_Custom_Field_Values {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    static int assetId;
    static String assetType;
    private static final String UID = "01CM57";
    private static final String FIELD1 = "/Fields/AssetName";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
        assetId = utilApi.getAssetId(titleId, assetType);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("field1", FIELD1);
        logger.debug((Object)"Test_57_Get_Asset_Metadata_Custom_Field_Values testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Field -> " + this.params.get("field1")));
        Assert.assertTrue((assetId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testEmptyTitleId - Value1 : " + this.response.get("value")));
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("value"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("field1", FIELD1);
        logger.debug((Object)"Test_57_Get_Asset_Metadata_Custom_Field_Values testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Field -> " + this.params.get("field1")));
        Assert.assertTrue((assetId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testNegativeTitleId - Value1 : " + this.response.get("value")));
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("value"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("field1", FIELD1);
        logger.debug((Object)"Test_57_Get_Asset_Metadata_Custom_Field_Values testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Field -> " + this.params.get("field1")));
        Assert.assertTrue((assetId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testStringAsTitleId - Value1 : " + this.response.get("value")));
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("value"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "");
        this.params.put("field1", FIELD1);
        logger.debug((Object)"Test_57_Get_Asset_Metadata_Custom_Field_Values testEmptyAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Field -> " + this.params.get("field1")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testEmptyAssetId - Value1 : " + this.response.get("value")));
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testEmptyAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("value"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "-1");
        this.params.put("field1", FIELD1);
        logger.debug((Object)"Test_57_Get_Asset_Metadata_Custom_Field_Values testNegativeAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Field -> " + this.params.get("field1")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testNegativeAssetId - Value1 : " + this.response.get("value")));
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testNegativeAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("value"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "abcd");
        this.params.put("field1", FIELD1);
        logger.debug((Object)"Test_57_Get_Asset_Metadata_Custom_Field_Values testStringAsAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Field -> " + this.params.get("field1")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testStringAsAssetId - Value1 : " + this.response.get("value")));
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testStringAsAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("value"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyField1() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("field1", "");
        logger.debug((Object)"Test_57_Get_Asset_Metadata_Custom_Field_Values testEmptyField1 Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Field -> " + this.params.get("field1")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        Assert.assertTrue((assetId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testEmptyField1 - Value1 : " + this.response.get("value")));
        logger.debug((Object)("Test_57_Get_Asset_Metadata_Custom_Field_Values testEmptyField1 - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("value"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        assetType = "POSTER";
        logger = Logger.getLogger(Test_57_Get_Asset_Metadata_Custom_Field_Values.class);
    }
}

