/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_64_Update_Title_Asset_For_Content {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    static int assetId;
    static String assetType;
    private static final String ASSET_PATH = "/opt/tandbergtv/cms/workflow/lib/content-management-template/poster.jpg";
    private static final String UID = "01CM64";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
        assetId = utilApi.getAssetId(titleId, assetType);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("assetPath", ASSET_PATH);
        logger.debug((Object)"Test_64_Update_Title_Asset_For_Content testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Asset Path -> " + this.params.get("assetPath")));
        Assert.assertTrue((assetId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testEmptyTitleId - File Id : " + this.response.get("fileId")));
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("assetPath", ASSET_PATH);
        logger.debug((Object)"Test_64_Update_Title_Asset_For_Content testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Asset Path -> " + this.params.get("assetPath")));
        Assert.assertTrue((assetId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testNegativeTitleId - File Id : " + this.response.get("fileId")));
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("assetPath", ASSET_PATH);
        logger.debug((Object)"Test_64_Update_Title_Asset_For_Content testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Asset Path -> " + this.params.get("assetPath")));
        Assert.assertTrue((assetId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testStringAsTitleId - File Id : " + this.response.get("fileId")));
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "");
        this.params.put("assetPath", ASSET_PATH);
        logger.debug((Object)"Test_64_Update_Title_Asset_For_Content testEmptyAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Asset Path -> " + this.params.get("assetPath")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testEmptyAssetId - File Id : " + this.response.get("fileId")));
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testEmptyAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "-1");
        this.params.put("assetPath", ASSET_PATH);
        logger.debug((Object)"Test_64_Update_Title_Asset_For_Content testNegativeAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Asset Path -> " + this.params.get("assetPath")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testNegativeAssetId - File Id : " + this.response.get("fileId")));
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testNegativeAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "abcd");
        this.params.put("assetPath", ASSET_PATH);
        logger.debug((Object)"Test_64_Update_Title_Asset_For_Content testStringAsAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Asset Path -> " + this.params.get("assetPath")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testStringAsAssetId - File Id : " + this.response.get("fileId")));
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testStringAsAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyAssetPath() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("assetPath", "");
        logger.debug((Object)"Test_64_Update_Title_Asset_For_Content testEmptyAssetPath Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " Asset Path -> " + this.params.get("assetPath")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        Assert.assertTrue((assetId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testEmptyAssetPath - File Id : " + this.response.get("fileId")));
        logger.debug((Object)("Test_64_Update_Title_Asset_For_Content testEmptyAssetPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        assetType = "PACKAGE";
        logger = Logger.getLogger(Test_64_Update_Title_Asset_For_Content.class);
    }
}

