/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_70_Export_Title_List {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleListId;
    private static final String dirPath;
    private static final String UID = "01CM70";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleListId = utilApi.getTitleListId();
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleListId() throws Exception {
        this.params.put("titleListId", "");
        this.params.put("dirPath", dirPath);
        logger.debug((Object)"Test_70_Export_Title_List testEmptyTitleListId Request Params");
        logger.debug((Object)("Title List Id -> " + this.params.get("titleListId") + " DirPath -> " + this.params.get("dirPath")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_70_Export_Title_List testEmptyTitleListId - File Path : " + this.response.get("filePath")));
        logger.debug((Object)("Test_70_Export_Title_List testEmptyTitleListId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("filePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleListId() throws Exception {
        this.params.put("titleListId", "-1");
        this.params.put("dirPath", dirPath);
        logger.debug((Object)"Test_70_Export_Title_List testNegativeTitleListId Request Params");
        logger.debug((Object)("Title List Id -> " + this.params.get("titleListId") + " DirPath -> " + this.params.get("dirPath")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_70_Export_Title_List testNegativeTitleListId - File Path : " + this.response.get("filePath")));
        logger.debug((Object)("Test_70_Export_Title_List testNegativeTitleListId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("filePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleListId() throws Exception {
        this.params.put("titleListId", "abcd");
        this.params.put("dirPath", dirPath);
        logger.debug((Object)"Test_70_Export_Title_List testStringAsTitleListId Request Params");
        logger.debug((Object)("Title List Id -> " + this.params.get("titleListId") + " DirPath -> " + this.params.get("dirPath")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_70_Export_Title_List testStringAsTitleListId - File Path : " + this.response.get("filePath")));
        logger.debug((Object)("Test_70_Export_Title_List testStringAsTitleListId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("filePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyDirPath() throws Exception {
        this.params.put("titleListId", String.valueOf(titleListId));
        this.params.put("dirPath", "");
        logger.debug((Object)"Test_70_Export_Title_List testEmptyDirPath Request Params");
        logger.debug((Object)("Title List Id -> " + this.params.get("titleListId") + " DirPath -> " + this.params.get("dirPath")));
        Assert.assertTrue((titleListId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_70_Export_Title_List testEmptyDirPath - File Path : " + this.response.get("filePath")));
        logger.debug((Object)("Test_70_Export_Title_List testEmptyDirPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("filePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        dirPath = System.getProperty("java.io.tmpdir");
        logger = Logger.getLogger(Test_70_Export_Title_List.class);
    }
}

