/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_86_Associate_Title_to_Series {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    static int titleId;
    static String seriesId;
    Map<String, String> params;
    Map<String, Object> response;
    private static final String UID = "01CM86";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
        seriesId = utilApi.getSeriesIds();
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("seriesId", seriesId);
        logger.debug((Object)"Test_86_Associate_Title_to_Series testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Series ID : " + this.params.get("seriesId")));
        Assert.assertNotNull((Object)seriesId);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_86_Associate_Title_to_Series testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("seriesId", seriesId);
        logger.debug((Object)"Test_86_Associate_Title_to_Series testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Series ID : " + this.params.get("seriesId")));
        Assert.assertNotNull((Object)seriesId);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_86_Associate_Title_to_Series testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("seriesId", seriesId);
        logger.debug((Object)"Test_86_Associate_Title_to_Series testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Series ID : " + this.params.get("seriesId")));
        Assert.assertNotNull((Object)seriesId);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_86_Associate_Title_to_Series testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptySeriesId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("seriesId", "");
        logger.debug((Object)"Test_86_Associate_Title_to_Series testEmptySeriesId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Series ID : " + this.params.get("seriesId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_86_Associate_Title_to_Series testEmptySeriesId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeSeriesId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("seriesId", "-1");
        logger.debug((Object)"Test_86_Associate_Title_to_Series testNegativeSeriesId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Series ID : " + this.params.get("seriesId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_86_Associate_Title_to_Series testNegativeSeriesId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsSeriesId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("seriesId", "abcd");
        logger.debug((Object)"Test_86_Associate_Title_to_Series testStringAsSeriesId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Series ID : " + this.params.get("seriesId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_86_Associate_Title_to_Series testStringAsSeriesId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeSeasonId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("seriesId", seriesId);
        this.params.put("seasonId", "-1");
        logger.debug((Object)"Test_86_Associate_Title_to_Series testNegativeSeasonId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Series ID : " + this.params.get("seriesId") + " Season ID : " + this.params.get("seasonId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)seriesId);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_86_Associate_Title_to_Series testNegativeSeasonId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsSeasonId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("seriesId", seriesId);
        this.params.put("seasonId", "abcd");
        logger.debug((Object)"Test_86_Associate_Title_to_Series testStringAsSeasonId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Series ID : " + this.params.get("seriesId") + " Season ID : " + this.params.get("seasonId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)seriesId);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_86_Associate_Title_to_Series testStringAsSeasonId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        logger = Logger.getLogger(Test_86_Associate_Title_to_Series.class);
    }
}

