/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_88_Add_Asset {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    static int titleId;
    Map<String, String> params;
    Map<String, Object> response;
    private static final String UID = "01CM88";
    private static final String ASSET_TYPE = "POSTER";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("assetType", ASSET_TYPE);
        logger.debug((Object)"Test_88_Add_Asset testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Asset Type -> " + this.params.get("assetType")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_88_Add_Asset testEmptyTitleId - Asset Id : " + this.response.get("assetId")));
        logger.debug((Object)("Test_88_Add_Asset testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("assetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("assetType", ASSET_TYPE);
        logger.debug((Object)"Test_88_Add_Asset testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Asset Type -> " + this.params.get("assetType")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_88_Add_Asset testNegativeTitleId - Asset Id : " + this.response.get("assetId")));
        logger.debug((Object)("Test_88_Add_Asset testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("assetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("assetType", ASSET_TYPE);
        logger.debug((Object)"Test_88_Add_Asset testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Asset Type -> " + this.params.get("assetType")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_88_Add_Asset testStringAsTitleId - Asset Id : " + this.response.get("assetId")));
        logger.debug((Object)("Test_88_Add_Asset testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("assetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyAssetType() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetType", "");
        logger.debug((Object)"Test_88_Add_Asset testEmptyAssetType Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Asset Type -> " + this.params.get("assetType")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_88_Add_Asset testEmptyAssetType - Asset Id : " + this.response.get("assetId")));
        logger.debug((Object)("Test_88_Add_Asset testEmptyAssetType - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("assetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidAssetType() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetType", "abcd1234");
        logger.debug((Object)"Test_88_Add_Asset testInvalidAssetType Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Asset Type -> " + this.params.get("assetType")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_88_Add_Asset testInvalidAssetType - Asset Id : " + this.response.get("assetId")));
        logger.debug((Object)("Test_88_Add_Asset testInvalidAssetType - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("assetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeParentAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetType", ASSET_TYPE);
        this.params.put("parentAssetId", "-1");
        logger.debug((Object)"Test_88_Add_Asset testNegativeParentAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Asset Type -> " + this.params.get("assetType") + " Parent Asset ID -> " + this.params.get("parentAssetId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_88_Add_Asset testNegativeParentAssetId - Asset Id : " + this.response.get("assetId")));
        logger.debug((Object)("Test_88_Add_Asset testNegativeParentAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("assetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsParentAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetType", ASSET_TYPE);
        this.params.put("parentAssetId", "abcd");
        logger.debug((Object)"Test_88_Add_Asset testStringAsParentAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Asset Type -> " + this.params.get("assetType") + " Parent Asset ID -> " + this.params.get("parentAssetId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_88_Add_Asset testStringAsParentAssetId - Asset Id : " + this.response.get("assetId")));
        logger.debug((Object)("Test_88_Add_Asset testStringAsParentAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("assetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        logger = Logger.getLogger(Test_88_Add_Asset.class);
    }
}

