/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UtilApi {
    String destUrl;
    String UID;
    static SoapCaller soapCaller;
    Map<String, String> params;
    Map<String, Object> response;
    String msgOrigin = "171381";
    MessageKeyImpl messageKey = new MessageKeyImpl((Object)this.msgOrigin);
    IMessageKey messageOrigin = this.messageKey;
    private static Logger logger;

    public UtilApi() throws IOException {
        this.params = new HashMap<String, String>();
        soapCaller = new SoapCaller();
        this.destUrl = soapCaller.getUrl();
    }

    public int createTitleForMetadata() throws Exception {
        int titleId;
        logger.debug((Object)("UtilApi : CreateTitleforMetadata MessageOrigin -> " + this.messageOrigin));
        this.UID = "01CM40";
        String metadataFilePath = "/opt/tandbergtv/cms/workflow/lib/content-management-template/ADI_TTV_474080.xml";
        this.params.put("metadataPath", metadataFilePath);
        this.params.put("providerId", "TTV.COM");
        this.params.put("contentClassName", "Default");
        this.response = soapCaller.invokeApi(this.UID, this.messageOrigin, this.params);
        logger.debug((Object)("UtilApi : CreateTitelforMetadata -> Title Id " + this.response.get("titleId")));
        if (this.response.get("error-message") != null) {
            titleId = -1;
            logger.debug((Object)("UtilApi : CreateTitelforMetadata -> Error Message" + this.response.get("error-message")));
        } else {
            titleId = Integer.valueOf((String)this.response.get("titleId"));
        }
        return titleId;
    }

    public void deleteMasterTitle(int titleId) throws Exception {
        logger.debug((Object)("UtilApi : DeleteMasterTitle MessageOrigin -> " + this.messageOrigin));
        this.UID = "01CM05";
        this.params.put("titleId", String.valueOf(titleId));
        this.response = soapCaller.invokeApi(this.UID, this.messageOrigin, this.params);
        if (this.response.get("error-message") != null) {
            logger.debug((Object)("UtilApi : DeleteMasterTitle -> Error Message" + this.response.get("error-message")));
        } else {
            logger.debug((Object)("UtilApi :DeleteMasterTitle -> Successfully deleted Title : " + titleId));
        }
    }

    public int getAssetId(int titleId, String assetType) throws Exception {
        int assetId;
        logger.debug((Object)("UtilApi : GetAssetId MessageOrigin -> " + this.messageOrigin));
        this.UID = "01CM28";
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetType", assetType);
        this.response = soapCaller.invokeApi(this.UID, this.messageOrigin, this.params);
        if (this.response.get("error-message") != null) {
            assetId = -1;
            logger.debug((Object)("UtilApi : GetAssetId -> Error Message" + this.response.get("error-message")));
        } else {
            logger.debug((Object)("UtilApi :GetAssetId -> Asset Id  : " + this.response.get("assetId")));
            assetId = Integer.valueOf((String)this.response.get("assetId"));
        }
        return assetId;
    }

    public int getTitleListId() throws Exception {
        int titleListId;
        logger.debug((Object)("UtilApi : GetTitleListId MessageOrigin -> " + this.messageOrigin));
        this.UID = "01CM81";
        this.response = soapCaller.invokeApi(this.UID, this.messageOrigin, this.params);
        if (this.response.get("error-message") != null) {
            titleListId = -1;
            logger.debug((Object)("UtilApi : GetTitleListId -> Error Message" + this.response.get("error-message")));
        } else {
            logger.debug((Object)("UtilApi :GetTitleListId -> Title List Ids  : " + this.response.get("titleListIds")));
            String listIDs = (String)this.response.get("titleListIds");
            logger.debug((Object)("UtilApi :GetTitleListId -> ListIDS  : " + listIDs));
            String[] list = listIDs.split(",");
            titleListId = list.length > 0 ? Integer.valueOf(list[0]) : -1;
        }
        return titleListId;
    }

    public int getOriginalFileId(int titleId, int assetId, String lookUpKey) throws Exception {
        int fileId;
        logger.debug((Object)("UtilApi : GetOriginalFileId MessageOrigin -> " + this.messageOrigin));
        this.UID = "01CM74";
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", lookUpKey);
        logger.debug((Object)("UtilApi : GetOriginalFileId Title ID -> " + this.params.get("titleId") + " Asset ID -> " + this.params.get("assetId") + " Lookup Key -> " + this.params.get("lookupKey")));
        this.response = soapCaller.invokeApi(this.UID, this.messageOrigin, this.params);
        if (this.response.get("error-message") != null) {
            logger.debug((Object)("UtilApi : GetOriginalFileId File ID -> " + this.response.get("fileId")));
            fileId = -1;
        } else {
            logger.debug((Object)("UtilApi : GetOriginalFileId File ID -> " + this.response.get("fileId")));
            fileId = Integer.valueOf((String)this.response.get("fileId"));
        }
        return fileId;
    }

    public String getFileURI(int titleId, int assetId, String lookUpKey) throws Exception {
        String fileUri;
        logger.debug((Object)("UtilApi : GetFileURI MessageOrigin -> " + this.messageOrigin));
        this.UID = "01CM74";
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", lookUpKey);
        logger.debug((Object)("UtilApi : GetOriginalFileId Title ID -> " + this.params.get("titleId") + " Asset ID -> " + this.params.get("assetId") + " Lookup Key -> " + this.params.get("lookupKey")));
        this.response = soapCaller.invokeApi(this.UID, this.messageOrigin, this.params);
        if (this.response.get("error-message") != null) {
            fileUri = null;
            logger.debug((Object)("UtilApi : GetFileURI File Uri -> " + this.response.get("fileUri")));
        } else {
            logger.debug((Object)("UtilApi : GetFileURI File Uri -> " + this.response.get("fileUri")));
            fileUri = (String)this.response.get("fileUri");
        }
        return fileUri;
    }

    public String getSeriesIds() throws Exception {
        String FIELD1_XPATH = "/Fields/AssetName";
        String FIELD1_ASSET_TYPE = "SERIES";
        String FIELD1_VALUE = "Demo";
        this.UID = "01CM85";
        this.params.put("field1Xpath", FIELD1_XPATH);
        this.params.put("field1AssetType", FIELD1_ASSET_TYPE);
        this.params.put("field1Value", FIELD1_VALUE);
        logger.debug((Object)"UtilApi GetSeriesIds : ");
        logger.debug((Object)("Field1 XPath -> " + this.params.get("field1Xpath") + " Field1 AssetType -> " + this.params.get("field1AssetType") + " Field1 Value -> " + this.params.get("field1Value")));
        this.response = soapCaller.invokeApi(this.UID, this.messageOrigin, this.params);
        logger.debug((Object)("UtilApi GetSeriesIds : Series Ids " + this.response.get("seriesIds")));
        return (String)this.response.get("seriesIds");
    }

    static {
        logger = Logger.getLogger(UtilApi.class);
    }
}

