/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class SoapCaller {
    private String destinationUrl;
    private static int urlSet = 0;
    private Logger logger = Logger.getLogger(SoapCaller.class);

    public SoapCaller(String destinationUrl) {
        this.destinationUrl = destinationUrl;
    }

    public SoapCaller() throws IOException {
        Properties prop = new Properties();
        String filePath = "/opt/tandbergtv/cms/workflow/lib/site-manager-template/SiteManagerTest.properties";
        prop.load(new FileInputStream(filePath));
        this.destinationUrl = prop.getProperty("url");
        if (urlSet == 0) {
            this.logger.debug((Object)("SoapCaller : Adapater Services URL -> " + this.destinationUrl));
            urlSet = 1;
        }
    }

    public String getUrl() {
        return this.destinationUrl;
    }

    private WorkflowMessage prepareMessage(String UID, IMessageKey messageOrigin, Map<String, String> params) throws InvalidPropertiesFormatException, IOException {
        WorkflowMessage message = null;
        MessageUIDImpl messageUID = new MessageUIDImpl(UID);
        message = new WorkflowMessage((IMessageUID)messageUID, messageOrigin, messageOrigin, WorkflowMessage.MessageType.control);
        message.setPayload(new WorkflowPayload());
        for (Map.Entry<String, String> paramEntry : params.entrySet()) {
            message.putValue(paramEntry.getKey(), paramEntry.getValue());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> send(WorkflowMessage wfsMessage) throws Exception {
        Document doc = Marshaller.newMarshaller().marshal(wfsMessage);
        SOAPMessage message = MessageFactory.newInstance().createMessage();
        MimeHeaders headers = message.getMimeHeaders();
        headers.addHeader("SOAPAction", "");
        SOAPBody requestBody = message.getSOAPBody();
        requestBody.addDocument(doc);
        SOAPConnection connection = null;
        SOAPMessage reply = null;
        try {
            connection = SOAPConnectionFactory.newInstance().createConnection();
            reply = connection.call(message, (Object)this.destinationUrl);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        SOAPBody body = reply.getSOAPBody();
        if (body.getFault() != null) {
            SOAPFault fault = body.getFault();
            throw new SOAPException("SoapCaller : Got a soap fault in the response: " + fault.getFaultString());
        }
        Document responseDocument = body.extractContentAsDocument();
        WorkflowMessage responseMessage = Unmarshaller.unmarshal((Document)responseDocument);
        if (responseMessage.getType() == WorkflowMessage.MessageType.nack) {
            this.logger.debug((Object)("SoapCaller : Nack response received | Response Message: " + responseMessage.toString()));
        }
        return responseMessage.getParameters();
    }

    public Map<String, Object> invokeApi(String UID, IMessageKey messageOrigin, Map<String, String> params) throws Exception {
        WorkflowMessage wMsg = this.prepareMessage(UID, messageOrigin, params);
        return this.send(wMsg);
    }

    public Map<String, Object> invokeApi(String UID, Map<String, String> params) throws Exception {
        WorkflowMessage wMsg = this.prepareMessage(UID, null, params);
        return this.send(wMsg);
    }
}

