/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SoapCaller;
import com.ericsson.cms.devices.sites.TestCreateSiteTitle;
import com.ericsson.cms.devices.sites.UtilApi;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGenerateChangeXML {
    static String destUrl;
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    String UID;
    Map<String, String> params;
    Map<String, Object> response;
    private Logger logger = Logger.getLogger(TestCreateSiteTitle.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        destUrl = soapCaller.getUrl();
        utilApi = new UtilApi(destUrl);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.UID = null;
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        destUrl = null;
        soapCaller = null;
        utilApi = null;
    }

    @Test
    public void testEmptySiteTitleId() throws Exception {
        this.UID = "01SM21";
        this.params.put("SiteTitleID", "");
        this.params.put("ChangeXMLFilePath", "C:/content/unmapped");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGenerateChangeXML EmptySiteTitleId: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeSiteTitleId() throws Exception {
        this.UID = "01SM21";
        this.params.put("SiteTitleID", "-20");
        this.params.put("ChangeXMLFilePath", "C:/content/unmapped");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGenerateChangeXML NegativeSiteTitleId: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.UID = "01SM21";
        this.params.put("SiteTitleID", "abcd");
        this.params.put("ChangeXMLFilePath", "C:/content/unmapped");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGenerateChangeXML NegativeSiteTitleId: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyChangeXMLFilePath() throws Exception {
        int sId = utilApi.getSiteId("TestMediaPathSite");
        Assert.assertTrue((sId > 0 ? 1 : 0) != 0);
        this.logger.debug((Object)("TestGenerateChangeXML EmptyChangeXMLFilePath: SiteId - " + sId));
        this.UID = "01SM21";
        this.params.put("SiteTitleID", String.valueOf(sId));
        this.params.put("ChangeXMLFilePath", "");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGenerateChangeXML EmptyChangeXMLFilePath: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidChangeXMLFilePath() throws Exception {
        int sId = utilApi.getSiteId("TestMediaPathSite");
        Assert.assertTrue((sId > 0 ? 1 : 0) != 0);
        this.logger.debug((Object)("TestGenerateChangeXML InvalidChangeXMLFilePath: SiteId - " + sId));
        this.UID = "01SM21";
        this.params.put("SiteTitleID", String.valueOf(sId));
        this.params.put("ChangeXMLFilePath", "acdbhdju8");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGenerateChangeXML InvalidChangeXMLFilePath: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }
}

