/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SoapCaller;
import com.ericsson.cms.devices.sites.TestCreateSiteTitle;
import com.ericsson.cms.devices.sites.UtilApi;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGetSiteProperties {
    static String destUrl;
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    String UID;
    Map<String, String> params;
    Map<String, Object> response;
    private Logger logger = Logger.getLogger(TestCreateSiteTitle.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        destUrl = soapCaller.getUrl();
        utilApi = new UtilApi(destUrl);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.UID = null;
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        destUrl = null;
        soapCaller = null;
        utilApi = null;
    }

    @Test
    public void testEmptySiteId() throws Exception {
        this.UID = "01SM06";
        this.params.put("SiteID", "");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteProperties EmptySiteID: ErrorMessage -" + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("MetadataFormat"));
        Assert.assertNull((Object)this.response.get("ExternalID"));
        Assert.assertNull((Object)this.response.get("Type"));
        Assert.assertNull((Object)this.response.get("LookupKeys"));
        Assert.assertNull((Object)this.response.get("SiteName"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeSiteId() throws Exception {
        this.UID = "01SM06";
        this.params.put("SiteID", "-20");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteProperties NegativeSiteID: ErrorMessage -" + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("MetadataFormat"));
        Assert.assertNull((Object)this.response.get("ExternalID"));
        Assert.assertNull((Object)this.response.get("Type"));
        Assert.assertNull((Object)this.response.get("LookupKeys"));
        Assert.assertNull((Object)this.response.get("SiteName"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsSiteId() throws Exception {
        this.UID = "01SM06";
        this.params.put("SiteID", "abcd");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteProperties StringAsSiteID: ErrorMessage -" + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("MetadataFormat"));
        Assert.assertNull((Object)this.response.get("ExternalID"));
        Assert.assertNull((Object)this.response.get("Type"));
        Assert.assertNull((Object)this.response.get("LookupKeys"));
        Assert.assertNull((Object)this.response.get("SiteName"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInActiveSite() throws Exception {
        int sId = utilApi.getSiteId("TestLogicalSite");
        Assert.assertTrue((sId > 0 ? 1 : 0) != 0);
        this.logger.debug((Object)("TestGetSiteProperties InactiveSite: SiteId - " + sId));
        this.UID = "01SM06";
        this.params.put("SiteID", "abcd");
        this.logger.debug((Object)("TestGetSiteProperties-Deactivating the Site : SiteID " + sId));
        utilApi.deactivateSite(sId);
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteProperties InActiveSite: ErrorMessage -" + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("MetadataFormat"));
        Assert.assertNull((Object)this.response.get("ExternalID"));
        Assert.assertNull((Object)this.response.get("Type"));
        Assert.assertNull((Object)this.response.get("LookupKeys"));
        Assert.assertNull((Object)this.response.get("SiteName"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
        this.logger.debug((Object)("TestGetSiteProperties-Activating back the Site : SiteID " + sId));
        utilApi.activateSite(sId);
    }
}

