/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SoapCaller;
import com.ericsson.cms.devices.sites.UtilApi;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNotifyDeploymentInProgress {
    static String destUrl;
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    String UID;
    Map<String, String> params;
    Map<String, Object> response;
    private Logger logger = Logger.getLogger(TestNotifyDeploymentInProgress.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        destUrl = soapCaller.getUrl();
        utilApi = new UtilApi(destUrl);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.UID = null;
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        destUrl = null;
        soapCaller = null;
        utilApi = null;
    }

    @Test
    public void testEmptySiteTitleId() throws Exception {
        this.UID = "01SM19";
        this.params.put("SiteTitleID", "");
        this.params.put("TrackingSiteExternalId", "tts");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestNotifyDEploymentInProgress EmptySiteTitleId: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeSiteTitleId() throws Exception {
        this.UID = "01SM19";
        this.params.put("SiteTitleID", "-24");
        this.params.put("TrackingSiteExternalId", "tts");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestNotifyDEploymentInProgress NegativeSiteTitleId: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsSiteTitleId() throws Exception {
        this.UID = "01SM19";
        this.params.put("SiteTitleID", "abcd");
        this.params.put("TrackingSiteExternalId", "tts");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestNotifyDEploymentInProgress StringAsSiteTitleId: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyTrackingSiteExternalId() throws Exception {
        this.UID = "01SM19";
        this.params.put("SiteTitleID", "653");
        this.params.put("TrackingSiteExternalId", "");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestNotifyDEploymentInProgress EmptyTrackingSiteExternalId: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTrackingSiteExternalId() throws Exception {
        this.UID = "01SM19";
        this.params.put("SiteTitleID", "653");
        this.params.put("TrackingSiteExternalId", "-26");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestNotifyDEploymentInProgress NegativeTrackingSiteExternalId: Response Message -" + this.response.toString()));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }
}

