/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SoapCaller;
import com.ericsson.cms.sites.core.ISiteManagerRemote;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class UtilApi {
    ISiteManagerRemote siteManager;
    String destUrl;
    String UID;
    SoapCaller soapCaller;
    Map<String, String> params;
    Map<String, Object> response;
    private Logger logger = Logger.getLogger(UtilApi.class);

    public UtilApi(String destinationUrl) throws IOException {
        this.params = new HashMap<String, String>();
        this.soapCaller = new SoapCaller();
        this.destUrl = destinationUrl;
        this.siteManager = null;
    }

    public int createTitleForMetadata() {
        MessageKeyImpl messageKey;
        int titleId = -1;
        String msgOrigin = "171219";
        MessageKeyImpl messageOrigin = messageKey = new MessageKeyImpl((Object)msgOrigin);
        this.logger.debug((Object)("UtilApi : CreateTitleforMetadata MessageOrigin -> " + msgOrigin));
        this.UID = "01CM40";
        String metadataFilePath = "/opt/tandbergtv/cms/workflow/lib/site-manager-template/ADI_TTV_474080.xml";
        this.params.put("metadataPath", metadataFilePath);
        this.params.put("providerId", "TTV.COM");
        this.params.put("contentClassName", "Default");
        try {
            this.response = this.soapCaller.invokeApi(this.UID, (IMessageKey)messageOrigin, this.params);
            this.logger.debug((Object)("UtilApi : CreateTitelforMetadata -> Title Id " + this.response.get("titleId")));
            if (this.response.get("error-message") != null) {
                this.logger.debug((Object)("UtilApi : CreateTitelforMetadata -> Error Message" + this.response.get("error-message")));
            } else {
                titleId = Integer.valueOf((String)this.response.get("titleId"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"UtilAPi : Failed to Create Title for Metadata", (Throwable)e);
        }
        return titleId;
    }

    public void deleteMasterTitle(int titleId) {
        MessageKeyImpl messageKey;
        String msgOrigin = "171219";
        MessageKeyImpl messageOrigin = messageKey = new MessageKeyImpl((Object)msgOrigin);
        this.logger.debug((Object)("UtilApi : DeleteMasterTitle MessageOrigin -> " + msgOrigin));
        this.UID = "01CM05";
        this.params.put("titleId", String.valueOf(titleId));
        try {
            this.response = this.soapCaller.invokeApi(this.UID, (IMessageKey)messageOrigin, this.params);
            if (this.response.get("error-message") != null) {
                this.logger.debug((Object)("UtilApi : DeleteMasterTitle -> Error Message" + this.response.get("error-message")));
            } else {
                this.logger.debug((Object)("UtilApi :DeleteMasterTitle -> Successfully deleted Title : " + titleId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"UtilAPi : Failed to delete Title for Metadata", (Throwable)e);
        }
    }

    public int getSiteId(String siteName) {
        try {
            this.siteManager = (ISiteManagerRemote)this.getInitialContext("watchpoint-app:1099").lookup("cms/SiteManagerRemote/remote");
            Site site = this.siteManager.getSiteByName(siteName);
            if (site != null) {
                this.logger.debug((Object)("UtilApi getSiteId SiteID - " + site.getId()));
                return site.getId();
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("UtilAPi : Failed to Retreive Site Id for " + siteName), (Throwable)e);
            return -1;
        }
    }

    public void deactivateSite(int siteId) {
        try {
            this.siteManager = (ISiteManagerRemote)this.getInitialContext("watchpoint-app:1099").lookup("cms/SiteManagerRemote/remote");
            this.logger.debug((Object)("UtilApi deactivating Site :" + siteId));
            this.siteManager.inactivate(siteId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("UtilAPi : Failed to Deactivate Site Id for " + siteId), (Throwable)e);
        }
    }

    public void activateSite(int siteId) {
        try {
            this.siteManager = (ISiteManagerRemote)this.getInitialContext("watchpoint-app:1099").lookup("cms/SiteManagerRemote/remote");
            this.logger.debug((Object)("UtilApi activating Site :" + siteId));
            this.siteManager.activate(siteId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("UtilAPi : Failed to Activate Site Id for " + siteId), (Throwable)e);
        }
    }

    private InitialContext getInitialContext(String remoteAddress) throws NamingException {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        properties.put("java.naming.provider.url", remoteAddress);
        InitialContext context = new InitialContext(properties);
        return context;
    }
}

