/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.loggers;

import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.log.loggers.AbstractLogger;
import java.util.EventObject;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jbpm.logging.log.ProcessLog;

public class ProcessLogLogger
extends AbstractLogger {
    private static final Logger logger = Logger.getLogger(ProcessLogLogger.class);

    public ProcessLogLogger(SessionFactory sessionFactory, Integer count) {
        super(sessionFactory, count);
    }

    @Override
    public boolean match(EventObject eventObj, int index) {
        if (!(eventObj instanceof ProcessLogEvent)) {
            return false;
        }
        ProcessLogEvent event = (ProcessLogEvent)ProcessLogEvent.class.cast(eventObj);
        return event.getLog().getToken().getProcessInstance().getId() % (long)this.count == (long)index;
    }

    @Override
    public void execute(EventObject eventObj) {
        if (!(eventObj instanceof ProcessLogEvent)) {
            return;
        }
        ProcessLogEvent event = (ProcessLogEvent)eventObj;
        ProcessLog processLog = event.getLog();
        if (!event.isTrace()) {
            return;
        }
        logger.debug((Object)("Storing process log to database. Process Log: " + processLog));
        this.save(processLog);
    }
}

