/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph.exe;

import bsh.Interpreter;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.graph.exe.ListVariableInstance;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.context.exe.variableinstance.ByteArrayInstance;
import org.jbpm.context.exe.variableinstance.UnpersistableInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class ExecutionContext
extends org.jbpm.graph.exe.ExecutionContext {
    public ExecutionContext(Token token) {
        super(token);
    }

    public ExecutionContext(org.jbpm.graph.exe.ExecutionContext other) {
        super(other);
    }

    public Object getVariable(String name) {
        if (ListVariableInstance.check(name)) {
            return this.getListItem(name);
        }
        return this.evaluate(name);
    }

    public void setVariable(String name, Object value) {
        if (name.length() == 0) {
            throw new JbpmException("Variable name is an empty string");
        }
        if (value != null) {
            VariableInstance variable = VariableInstance.createVariableInstance((Object)value);
            if (variable instanceof UnpersistableInstance || variable instanceof ByteArrayInstance) {
                throw new JbpmException("Variable " + name + " uses unsupported data type - " + value.getClass().getName());
            }
            if (value.toString().length() >= 4000) {
                throw new JbpmException("Variable " + name + " exceeds max length (4000)");
            }
        }
        if (ListVariableInstance.check(name)) {
            ListVariableInstance list = this.getList(name);
            int index = this.index(name);
            list.set(index, value);
        } else {
            super.setVariable(name, value);
        }
    }

    public void setTaskInstance(TaskInstance taskInstance) {
        super.setTaskInstance(taskInstance);
        if (!this.validManualTask(taskInstance)) {
            return;
        }
        List variables = taskInstance.getTask().getTaskController().getVariableAccesses();
        if (variables == null) {
            return;
        }
        for (TaskVariable variable : variables) {
            if (!ListVariableInstance.check(variable.getVariableName())) continue;
            this.getListItem(variable.getVariableName());
        }
    }

    protected Object evaluate(String expression) {
        if (expression == null || expression.trim().isEmpty()) {
            throw new JbpmException("Missing variable name or expression");
        }
        Map variables = this.getContextInstance().getVariables(this.token);
        if (variables.containsKey(expression)) {
            return super.getVariable(expression);
        }
        try {
            Interpreter i = new Interpreter();
            for (Object key : variables.keySet()) {
                i.set((String)key, variables.get(key));
            }
            i.set("token", (Object)this.token);
            i.set("processInstance", (Object)this.token.getProcessInstance());
            i.set("_rootdir", (Object)System.getProperty("com.tandbergtv.cms.product.dir"));
            return i.eval(expression);
        }
        catch (Exception error) {
            throw new JbpmException("Error processing expression '" + expression + "'", (Throwable)error);
        }
    }

    private Object getListItem(String name) {
        ListVariableInstance list = this.getList(name);
        int index = this.index(name);
        return list.get(index);
    }

    private ListVariableInstance getList(String name) {
        String variableName = ListVariableInstance.parseVariableName(name);
        VariableInstance v = this.getVariableInstance(variableName);
        if (!(v instanceof ListVariableInstance)) {
            throw new IllegalArgumentException(this.token + ", " + variableName + " is not a list");
        }
        return (ListVariableInstance)v;
    }

    private VariableInstance getVariableInstance(String name) {
        ContextInstance ci = this.token.getProcessInstance().getContextInstance();
        TokenVariableMap map = ci.getTokenVariableMap(this.token);
        if (map == null) {
            return null;
        }
        return map.getVariableInstance(name);
    }

    private Integer index(String name) {
        int start = name.indexOf("[");
        int end = name.indexOf("]");
        String s = name.substring(start + 1, end);
        Object value = this.token.getProcessInstance().getContextInstance().getVariable(s);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.valueOf(s);
    }

    private boolean validManualTask(TaskInstance ti) {
        if (!(this.token.getNode() instanceof ManualTaskNode)) {
            return false;
        }
        return ti != null && ti.getCreate() == null && ti.getTask() != null && ti.getTask().getTaskController() != null;
    }
}

