/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph.exe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;

public class ListVariableInstance
extends VariableInstance {
    private static final long serialVersionUID = 5567529337015616053L;
    protected final String value = "LIST";
    public static final String START_TOKEN = "[";
    public static final String END_TOKEN = "]";
    public static final String SEPARATOR = ",";

    public boolean isStorable(Object value) {
        return value instanceof List;
    }

    public static boolean check(String name) {
        if (!name.contains(START_TOKEN) && !name.contains(END_TOKEN)) {
            return false;
        }
        if (name.contains(START_TOKEN) && !name.endsWith(END_TOKEN)) {
            throw new IllegalArgumentException("Invalid expression: " + name);
        }
        if (name.endsWith(END_TOKEN) && !name.contains(START_TOKEN)) {
            throw new IllegalArgumentException("Invalid expression: " + name);
        }
        return true;
    }

    public static String parseVariableName(String name) {
        if (!ListVariableInstance.check(name)) {
            throw new IllegalArgumentException("Invalid list expression: " + name);
        }
        return name.substring(0, name.indexOf(START_TOKEN));
    }

    public Object get(int index) {
        this.rangeCheck(index);
        return ((List)this.getObject()).get(index);
    }

    public void set(int index, Object value) {
        this.rangeCheck(index);
        List list = (List)this.getObject();
        list.set(index, value.toString());
        this.setObject(list);
    }

    protected Object getObject() {
        ContextInstance ci = this.token.getProcessInstance().getContextInstance();
        TokenVariableMap map = ci.getTokenVariableMap(this.token);
        TreeMap<Integer, String> sorted = new TreeMap<Integer, String>();
        for (VariableInstance variable : map.getVariableInstances().values()) {
            if (!variable.getName().startsWith(String.valueOf(this.name) + START_TOKEN)) continue;
            Integer index = this.index(variable.getName());
            sorted.put(index, variable.getValue().toString());
        }
        return new ArrayList(sorted.values());
    }

    protected void setObject(Object value) {
        ContextInstance ci = this.token.getProcessInstance().getContextInstance();
        this.removeListVariables(ci);
        List list = (List)value;
        int i = 0;
        while (i < list.size()) {
            ci.setVariable(String.valueOf(this.name) + START_TOKEN + i + END_TOKEN, list.get(i), this.token);
            ++i;
        }
        this.valueCache = null;
        this.isValueCached = false;
    }

    private void removeListVariables(ContextInstance ci) {
        Map variables;
        TokenVariableMap map = ci.getTokenVariableMap(this.token);
        if (map != null && (variables = map.getVariableInstances()) != null) {
            Iterator i = variables.values().iterator();
            while (i.hasNext()) {
                VariableInstance variable = (VariableInstance)i.next();
                if (!variable.getName().startsWith(String.valueOf(this.name) + START_TOKEN)) continue;
                i.remove();
            }
        }
    }

    private Integer index(String name) {
        int start = name.indexOf(START_TOKEN);
        int end = name.indexOf(END_TOKEN);
        String s = name.substring(start + 1, end);
        Object value = this.token.getProcessInstance().getContextInstance().getVariable(s);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.valueOf(s);
    }

    private void rangeCheck(int index) {
        List list = (List)this.getObject();
        if (index < 0 || index >= list.size()) {
            throw new IndexOutOfBoundsException("Invalid index " + index + " for " + this.name + ", size = " + list.size());
        }
    }
}

