/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.graph.exe.Transitions;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Loop
extends SuperState {
    private static final long serialVersionUID = -2696666366298339153L;
    private String variable;
    private String index;
    private int initialValue;
    private String expression;
    private static final Logger logger = Logger.getLogger(Loop.class);

    public Loop() {
    }

    public Loop(String name) {
        super(name);
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        super.read(element, jpdlReader);
        this.variable = element.attributeValue("variable");
        this.index = element.attributeValue("index");
        if (this.index == null || this.index.isEmpty()) {
            jpdlReader.addError("Node " + this.name + " does not have an index variable");
        }
        this.initialValue = Integer.valueOf(element.attributeValue("initialValue", "0"));
        this.expression = element.attributeValue("expression");
        if (this.nodes == null || this.nodes.isEmpty()) {
            jpdlReader.addError("Node " + this.name + " does not have child nodes");
        }
        logger.debug((Object)(String.valueOf(this.index) + " from " + this.initialValue + ", list " + this.variable + ", condition " + this.expression));
    }

    public void enter(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() != ProcessStatus.RUNNING) {
            throw new InvalidProcessStateException(token.toString());
        }
        logger.info((Object)(token + " (" + this.name + ")"));
        token.setNode((Node)this);
        context.setTransition(null);
        context.setTransitionSource(null);
        context.setVariable(this.index, (Object)this.initialValue);
        this.execute(context);
    }

    public void execute(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() != ProcessStatus.RUNNING && token.getStatus() != ProcessStatus.BUSY) {
            throw new InvalidProcessStateException(token.toString());
        }
        logger.info((Object)(token + " (" + this.name + ")"));
        while (this.evaluateExpression(context)) {
            if (this.start(token) || token.isResuming()) {
                Node node = token.getNode() == this ? this.first() : token.getCurrentNode();
                Transition transition = this.getArrivingTransition(node);
                context.setTransition(transition);
                transition.take(context);
            } else if (this.getNodeForEnter(context) != null) {
                this.getNodeForEnter(context).enter(context);
            } else {
                token.getNode().leave(context);
            }
            if (token.getStatus() != ProcessStatus.RUNNING) break;
            this.incrementIndex(context);
            token.setNode((Node)this);
        }
        if (token.getStatus() == ProcessStatus.RUNNING) {
            this.leave(context);
        }
    }

    public void leave(ExecutionContext context, Transition transition) {
        if (this != context.getNode()) {
            logger.warn((Object)(context.getToken() + " " + context.getToken().getNode()));
        }
        logger.info((Object)(context.getToken() + " (" + this.name + ")"));
        context.getToken().setNodeEnter(null);
        super.leave(context, transition);
    }

    public Transition getDefaultLeavingTransition() {
        Transition leaving = Transitions.createDefaultLeavingTransition((Node)this);
        if (leaving != null) {
            return leaving;
        }
        return super.getDefaultLeavingTransition();
    }

    protected Node getNodeForEnter(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        Node node = token.getNode();
        if (node.getSuperState() instanceof NodeGroup) {
            return node.getSuperState();
        }
        ProcessStatus status = token.getStatus();
        if (node instanceof AutomaticTaskNode || node instanceof ManualTaskNode && status != ProcessStatus.BUSY) {
            return node;
        }
        return null;
    }

    public Node first() {
        for (Object obj : this.nodes) {
            Node node = (Node)obj;
            if (node.getArrivingTransitions() != null && !node.getArrivingTransitions().isEmpty()) continue;
            return node;
        }
        throw new JbpmException(String.valueOf(this.name) + " has no nodes to delegate execution");
    }

    protected boolean start(Token token) {
        return token.getNode() == this;
    }

    protected void incrementIndex(ExecutionContext context) {
        Integer i = (Integer)context.getVariable(this.index);
        context.setVariable(this.index, (Object)(i + 1));
        logger.debug((Object)(context.getToken() + ", " + this.index + " = " + context.getVariable(this.index)));
    }

    protected boolean evaluateExpression(ExecutionContext context) {
        logger.debug((Object)("Expression " + this.expression));
        return Boolean.parseBoolean(JbpmExpressionEvaluator.evaluate((String)this.expression, (ExecutionContext)context).toString());
    }

    protected Transition getArrivingTransition(Node node) {
        if (node.getArrivingTransitions() != null && !node.getArrivingTransitions().isEmpty()) {
            return (Transition)node.getArrivingTransitions().iterator().next();
        }
        final Node target = node instanceof NodeGroup ? ((NodeGroup)NodeGroup.class.cast(node)).first() : node;
        Transition transition = new Transition(){
            private static final long serialVersionUID = 1L;

            public void take(ExecutionContext context) {
                CustomToken token = (CustomToken)context.getToken();
                token.setNode(target);
                token.setResuming(false);
                this.fireEvent("transition", context);
                if (token.getStatus() == ProcessStatus.RUNNING) {
                    target.enter(context);
                }
            }
        };
        transition.setTo(target);
        transition.setProcessDefinition(this.processDefinition);
        if (!(this.getSuperState() instanceof NodeGroup) && this.hasResourceGroup(target)) {
            this.addEvent(transition, "resource-request");
        }
        return transition;
    }

    protected void addEvent(Transition transition, String action) {
        Event event = new Event((GraphElement)transition, "transition");
        Action a = transition.getProcessDefinition().getAction(action);
        event.addAction(new Action(a.getActionDelegation()));
        transition.addEvent(event);
    }

    protected boolean hasResourceGroup(Node node) {
        Node n = this.getResourceGroupAwareNode(node);
        if (n instanceof ResourceGroupAware) {
            return ((ResourceGroupAware)ResourceGroupAware.class.cast(n)).getResourceGroupID() != null;
        }
        return false;
    }

    protected Node getResourceGroupAwareNode(Node node) {
        Node parent = node;
        while (parent.getSuperState() instanceof SuperState) {
            if (!((parent = parent.getSuperState()) instanceof NodeGroup)) continue;
            return parent;
        }
        return node;
    }
}

