/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.ui;

import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.internal.FileRecorderProperties;
import com.tandbergtv.workflow.monitor.internal.MetricProcessor;
import java.io.File;
import java.io.IOException;
import javax.management.JMException;
import org.apache.log4j.Logger;

public abstract class AbstractImageWriter
extends MetricProcessor {
    protected File root;
    private static final Logger logger = Logger.getLogger(AbstractImageWriter.class);

    protected AbstractImageWriter() {
    }

    @Override
    public void process() {
        this.pool.schedule(new Runnable(){

            @Override
            public void run() {
                for (Metric metricName : AbstractImageWriter.this.metricNames) {
                    try {
                        AbstractImageWriter.this.process(metricName);
                    }
                    catch (IOException e) {
                        logger.error((Object)"Error message", (Throwable)e);
                    }
                    catch (JMException e) {
                        logger.error((Object)"Error message", (Throwable)e);
                    }
                }
            }
        }, 0L, 120000L);
    }

    protected void process(Metric metricName) throws IOException, JMException {
        File dir = this.getOutputDirectory(metricName);
        File imageFile = FileRecorderProperties.getPNGFile(dir, metricName);
        this.writeImage(imageFile, metricName);
    }

    protected File getOutputDirectory(Metric metricName) {
        File images = new File(this.root, "images");
        File dir = new File(images, metricName.getType());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    protected abstract void writeImage(File var1, Metric var2);
}

